jQuery(document).ready(function($) {

    const $makeSelect = $('#ct-make-select');
    const $modelSelect = $('#ct-model-select');
    const $fuelSelect = $('#ct-fuel-select');
    const $variantSelect = $('#ct-variant-select');
    const $carMakeImages = $('#car-make-images');
    const $vehicleId = $('#ct-vehicle-id');
    $makeSelect.on('change', function() {
        fetchModels($(this).val());
    });

    $('.ct-car-make-image').on('click', function() {
        const makeId = $(this).data('make-id');
        $makeSelect.val(makeId).trigger('change');
    });

    $modelSelect.on('change', function() {
        fetchFuels($(this).val());
    });

    $(document).on('click', '.ct-car-model-image', function() {
        const modelId = $(this).data('model-id');
        $modelSelect.val(modelId).trigger('change');
        //fetchFuels(modelId);
    });

    $fuelSelect.on('change', function() {
        const selectedOption = $(this).find('option:selected');
        fetchVariant(selectedOption.val(), selectedOption.data('model-id'));
    });

    $(document).on('click', '.ct-car-fuel-image', function() {
        const modelId = $(this).data('model-id');
        const fuelId = $(this).data('fuel-id');
        $fuelSelect.val(fuelId).trigger('change');
    });


    $variantSelect.on('change', function() {
        const selectedOption = $(this).find('option:selected');
        const variantId = selectedOption.val();

        $('#ct-search-button').attr('data-button-variant-id', variantId);

        if (variantId) {
            $('#ct-search-button').removeAttr('disabled');
        } else {
            $('#ct-search-button').attr('disabled', true);
        }
        $('.ct-main-select-bg .ct-submit-button').addClass('ct-submit-button-active');
    });


    $(document).on('click', '#ct-search-button', function() {
        const variantId = $(this).attr('data-button-variant-id');

        if (variantId) {
            $variantSelect.val(variantId);
            fetchVehicleUrl(variantId);
        }
    });

    $(document).on('click', '#ct-vehicle-id', function() {
        event.preventDefault();
        const variantId = $(this).data('variant-id');
        $variantSelect.val(variantId).trigger('change');
        fetchVehicleUrl(variantId);
    });

    function getUrlParameters() {
        const urlPath = window.location.pathname;
        const pathParts = urlPath.split('/').filter(part => part);
        const rootPageSlug = ct_celtictuning.rootPageSlug;

        const rootPageIndex = pathParts.indexOf(rootPageSlug);

        if (rootPageIndex === -1) {
            return {}; //
        }

        return {
            makeName: pathParts[rootPageIndex + 1] || undefined,
            modalName: pathParts[rootPageIndex + 2] || undefined,
            fuelName: pathParts[rootPageIndex + 3] || undefined,
            variantName: pathParts[rootPageIndex + 4] || undefined
        };
    }

    const params = getUrlParameters();
    const rootPageSlugInPath = window.location.pathname.includes(ct_celtictuning.rootPageSlug);

    if (rootPageSlugInPath && (params.makeName || params.modalName || params.fuelName || params.variantName)) {
        fetchVehicleDetails(params.makeName, params.modalName, params.fuelName, params.variantName);
    }



    function populateSelects(data) {
        const makeOptions = data.makes
            .filter(make => make.Value !== "-1")
            .map(make => {
                const isSelected = make.Value === data.vehicle_data.MakeId ? 'selected' : '';
                return `<option value="${make.Value}" ${isSelected}>${make.Text}</option>`;
            }).join('');

        $makeSelect.html(`<option value="">Select Make</option>${makeOptions}`);
        $makeSelect.removeClass('ct-select-disabled');

        const modelOptions = data.models
            .filter(model => model.Value !== "-1")
            .map(model => {
                const isSelected = model.Value === data.vehicle_data.ModelId ? 'selected' : '';
                return `<option value="${model.Value}" ${isSelected}>${model.Text}</option>`;
            }).join('');

        $modelSelect.html(`<option value="">Select Model</option>${modelOptions}`);
        $modelSelect.removeClass('ct-select-disabled');

            // Check if data.fuels is an array and is defined
        const fuelOptions = Array.isArray(data.fuels) ? data.fuels
        .filter(fuel => fuel.Value !== "-1")
        .map(fuel => {
            const isSelected = String(fuel.Value) === String(data.vehicle_data.FuelType) ? 'selected' : '';
            return `<option data-model-id="${data.vehicle_data.ModelId}" value="${fuel.Value}" ${isSelected}>${fuel.Text}</option>`;
        }).join('') : '';

        $fuelSelect.html(`<option value="">Select Fuel</option>${fuelOptions}`);
        $fuelSelect.removeClass('ct-select-disabled');

        const variantOptions = Array.isArray(data.variants) ? data.variants
        .filter(variant => variant.Value !== "-1")
        .map(variant => {
            const isSelected = variant.Value === data.vehicle_data.VariantId ? 'selected' : '';
            return `<option value="${variant.Value}" ${isSelected}>${variant.Text}</option>`;
        }).join('') : '';

        $variantSelect.html(`<option value="">Select Variant</option>${variantOptions}`);
        $variantSelect.removeClass('ct-select-disabled');


            $('#ct-search-button').removeAttr('disabled');
            $('.ct-main-select-bg .ct-submit-button').addClass('ct-submit-button-active');
            $('#ct-search-button').attr('data-button-variant-id', data.vehicle_data.VariantId);
            if(data.vehicle_data.VariantId){
                updateVehicleSection(data.vehicle_data);
            }
    }

    function populateSelectsShortcode(data) {
        const makeOptions = data.makes
            .filter(make => make.Value !== "-1")
            .map(make => {
                const isSelected = make.Value === data.vehicle_data.MakeId ? 'selected' : '';
                return `<option value="${make.Value}" ${isSelected}>${make.Text}</option>`;
            }).join('');

            $('#ct-make-select-option').html(`<option value="">Select Make</option>${makeOptions}`);
            $('#ct-make-select-option').removeClass('ct-select-disabled');
            $('#ct-make-select-option').removeClass('ct-select-active-menu');
            $('#ct-make-select-option').addClass('ct-select-active-menu');


        const modelOptions = data.models
            .filter(model => model.Value !== "-1")
            .map(model => {
                const isSelected = model.Value === data.vehicle_data.ModelId ? 'selected' : '';
                return `<option value="${model.Value}" ${isSelected}>${model.Text}</option>`;
            }).join('');

            $('#ct-model-select-option').html(`<option value="">Select Model</option>${modelOptions}`);
            $('#ct-model-select-option').removeClass('ct-select-disabled');
            $('#ct-make-select-option').removeClass('ct-select-active-menu');
            $('#ct-model-select-option').addClass('ct-select-active-menu');
            if ( !data.fuels){
                return;
            }
        const fuelOptions = data.fuels
            .filter(fuel => fuel.Value !== "-1")
            .map(fuel => {
                const isSelected = String(fuel.Value) === String(data.vehicle_data.FuelType) ? 'selected' : '';
                return `<option data-model-id="${data.vehicle_data.ModelId}" value="${fuel.Value}" ${isSelected}>${fuel.Text}</option>`;
            }).join('');

            $('#ct-fuel-select-option').html(`<option value="">Select Fuel</option>${fuelOptions}`);
            $('#ct-fuel-select-option').removeClass('ct-select-disabled');
            $('#ct-model-select-option').removeClass('ct-select-active-menu');
            $('#ct-fuel-select-option').addClass('ct-select-active-menu');
        if (!data.variants){
            return;
        }
        const variantOptions = data.variants
            .filter(variant => variant.Value !== "-1")
            .map(variant => {
                const isSelected = variant.Value === data.vehicle_data.VariantId ? 'selected' : '';
                return `<option value="${variant.Value}" ${isSelected}>${variant.Text}</option>`;
            }).join('');

            $('#ct-variant-select-option').html(`<option value="">Select Variant</option>${variantOptions}`);
            $('#ct-fuel-select-option').removeClass('ct-select-active-menu');
            $('#ct-variant-select-option').addClass('ct-select-active-menu');
            $('#ct-variant-select-option').removeClass('ct-select-disabled');
            $('#ct-search-button-option').removeAttr('disabled');
            $('.ct-main-select-bg-shortcode .ct-submit-button').addClass('ct-submit-button-active');
            $('#ct-search-button-option').attr('data-button-variant-id', data.vehicle_data.VariantId);

    }

    function adjustImageHeight() {
        const $detailsSection = $('.details-section');
        const $imageSection = $('.ct-image-section-part');

        if ($detailsSection.length && $imageSection.length) {
            const width = $detailsSection.width();

            if (width < 850) {
                $imageSection.css('height', '300px');
            } else {
                $imageSection.css('height', '');
            }
        }
    }

    function fetchVehicleDetails(makeName, modalName, fuelName, variantName) {
        $('#loader').show();
        $carMakeImages.html('');
        const data = { action: 'fetch_vehicle_details' };
        if (makeName) data.make_name = makeName;
        if (modalName) data.modal_name = modalName;
        if (fuelName) data.fuel_name = fuelName;
        if (variantName) data.variant_name = variantName;

        $.ajax({
            url: ct_celtictuning.ajax_url,
            type: 'POST',
            data: data,
            success: function(response) {

                if (response.error) {
                    alert(response.error);
                    $('#loader').hide();
                    return;
                }

                if (response.make_id) {
                    fetchModels(response.make_id);
                    populateSelectsShortcode(response);
                    populateSelects(response);

                } else if (response.modal_id && response.fuel_type) {
                    fetchVariant(response.fuel_type, response.modal_id);
                    populateSelectsShortcode(response);
                    populateSelects(response);
                } else if (response.modal_id) {
                    fetchFuels(response.modal_id);
                    populateSelectsShortcode(response);
                    populateSelects(response);
                } else {
                    $fuelSelect.removeClass('ct-select-active-menu');
                    $modelSelect.removeClass('ct-select-active-menu');
                    $makeSelect.removeClass('ct-select-active-menu');
                    $variantSelect.removeClass('ct-select-active-menu');
                    populateSelects(response);
                    populateSelectsShortcode(response);
                    $('#ct-variant-select-option').removeClass('ct-select-active-menu');
                }
                adjustImageHeight();

                $('#loader').hide();
            }
        });
    }



    function fetchModels(makeId) {
        $('#loader').show();
        $.ajax({
            url: ct_celtictuning.ajax_url,
            type: 'POST',
            data: { action: 'fetch_models', make_id: makeId },
            success: function(response) {
                $('#loader').hide();

                if (!Array.isArray(response)) {
                    console.error("Expected an array but got:", response);
                    return;
                }

                const validModels = response.filter(model => model.Value !== "-1");
                updateModelSelect(validModels);
                updateCarMakeImages(validModels);
                const make = $makeSelect.find('option:selected').text().toLowerCase().replace(/ /g, '-');
                const baseUrl = ct_celtictuning.rootPageUrl;
                const newUrl = `${baseUrl}${make}/`;
                window.history.pushState({ path: newUrl }, '', newUrl);
            }
        });
    }

    function updateModelSelect(validModels) {
        const modelOptions = validModels.map(model =>
            `<option value="${model.Value}">${model.Text}</option>`
        ).join('');

        $modelSelect.html(`<option value="">Select a model</option>${modelOptions}`);
        $modelSelect.removeClass('ct-select-disabled');
        $modelSelect.addClass('ct-select-active-menu');
        $makeSelect.removeClass('ct-select-active-menu');
        $fuelSelect.removeClass('ct-select-active-menu');
        $variantSelect.removeClass('ct-select-active-menu');
        $fuelSelect.html(`<option value="">Select Previous</option>`).addClass('ct-select-disabled');
        $variantSelect.html(`<option value="">Select Previous</option>`).addClass('ct-select-disabled');
        $('#ct-search-button').attr('disabled', true); // Keep it disabled if no valid option is selected
        $('.ct-main-select-bg .ct-submit-button').removeClass('ct-submit-button-active');
    }

    function updateCarMakeImages(validModels) {
        const modelImages = validModels.map(model =>
            model.ImageUrl ? `
                <div class="col-md-2 col-6 mb-3">
                        <picture>
                            <img class="ct-car-model-image" data-model-id="${model.Value}" src="${model.ImageUrl}" alt="${model.Text}">
                        </picture>
                        <h3 class="ct-car-name">${model.Text}</h3>
                </div>` : ''
        ).join('');

        const htmlContent = `
            <div class="ct-container">
                <div class="row">
                    <div class="col-md-12">
                        <h2 class="my-4 ct-select-title">Please select your model</h2>
                    </div>
                    ${modelImages}
                </div>
            </div>`;

        $carMakeImages.html(htmlContent);
    }

    function fetchFuels(modelId) {
        $('#loader').show();
        $.ajax({
            url: ct_celtictuning.ajax_url,
            type: 'POST',
            data: { action: 'fetch_fuels', model_id: modelId },
            success: function(response) {
                $('#loader').hide();
                const validFuels = response.filter(fuel => fuel.Value !== "-1");
                updateFuelSelect(validFuels, modelId);
                updateFuelImages(validFuels, modelId);
                const make = $makeSelect.find('option:selected').text().toLowerCase().replace(/ /g, '-');
                const model = $modelSelect.find('option:selected').text().toLowerCase().replace(/[^a-z0-9-]/g, '-').replace(/-+/g, '-'); // Normalize hyphens
                const modelText = model.endsWith('-') ? model.slice(0, -1) : model;
                const baseUrl = ct_celtictuning.rootPageUrl;
                const newUrl = `${baseUrl}${make}/${modelText}/`;
                window.history.pushState({ path: newUrl }, '', newUrl);
            }
        });
    }

    function updateFuelSelect(validFuels, modelId) {
        const fuelOptions = validFuels.map(fuel =>
            `<option data-model-id="${modelId}" value="${fuel.Value}">${fuel.Text}</option>`
        ).join('');

        $fuelSelect.html(`<option value="">Select a fuel type</option>${fuelOptions}`);
        $fuelSelect.removeClass('ct-select-disabled');
        $fuelSelect.addClass('ct-select-active-menu');
        $modelSelect.removeClass('ct-select-active-menu');
        $makeSelect.removeClass('ct-select-active-menu');
        $variantSelect.removeClass('ct-select-active-menu');
        $variantSelect.html(`<option value="">Select Previous</option>`).addClass('ct-select-disabled');
        $('#ct-search-button').attr('disabled', true); // Keep it disabled if no valid option is selected
        $('.ct-main-select-bg .ct-submit-button').removeClass('ct-submit-button-active');
    }

    function updateFuelImages(validFuels, modelId) {
        const fuelImages = validFuels.map(fuel => {
            let imageSrc;
            if (fuel.Text === 'Diesel') {
                imageSrc = `${ct_celtictuning.pluginUrl}assets/images/diesel.svg`;
            } else if (fuel.Text === 'Petrol') {
                imageSrc = `${ct_celtictuning.pluginUrl}assets/images/petrol.svg`;
            }

            return imageSrc ? `
                <div class="col-6 mb-3 mb-md-0">
                        <img class="ct-car-fuel-image" src="${imageSrc}" alt="${fuel.Text}" data-fuel-id="${fuel.Value}" data-model-id="${modelId}">
                        <h4 class="ct-car-name">${fuel.Text}</h4>
                </div>` : '';
        }).join('');

        const fuelHtml = fuelImages.length > 0 ? `
            <div class="row ct-fuel-row">
                <div class="col-md-12">
                    <h2 class="my-4 ct-select-title">Please select fuel type</h2>
                </div>
                ${fuelImages}
            </div>` : `
            <div class="row ct-fuel-row">
                <div class="col-md-12 text-center">
                    <h2 class="my-4">No fuel variants available</h2>
                </div>
            </div>`;

        $carMakeImages.html(fuelHtml).removeClass('ct-container').addClass('ct-container ct-fuel-container');
    }


    function fetchVariant(fuelId, modelId) {
        $('#loader').show();
        $.ajax({
            url: ct_celtictuning.ajax_url,
            type: 'POST',
            data: { action: 'fetch_varients', fuel_id: fuelId, model_id: modelId },
            success: function(response) {
                $('#loader').hide();
                if (!Array.isArray(response)) {
                    console.error("Expected an array but got:", response);
                    return;
                }

                const validVariants = response.filter(variant => variant.Value !== "-1");
                updateVariantSelect(validVariants);
                updateVariantImages(validVariants);
                const make = $makeSelect.find('option:selected').text().toLowerCase().replace(/ /g, '-');
                const model = $modelSelect.find('option:selected').text().toLowerCase().replace(/[^a-z0-9-]/g, '-').replace(/-+/g, '-'); // Normalize hyphens
                const fuelType = $fuelSelect.find('option:selected').text().toLowerCase().replace(/ /g, '-');
                const modelText = model.endsWith('-') ? model.slice(0, -1) : model;
                const baseUrl = ct_celtictuning.rootPageUrl;
                const newUrl = `${baseUrl}${make}/${modelText}/${fuelType}/`;
                window.history.pushState({ path: newUrl }, '', newUrl);
            }
        });
    }

    function updateVariantSelect(validVariants) {
        const variantOptions = validVariants.map(variant =>
            `<option value="${variant.Value}">${variant.Text}</option>`
        ).join('');

        $variantSelect.html(`<option value="">Select a variant</option>${variantOptions}`);
        $variantSelect.removeClass('ct-select-disabled');
        $variantSelect.addClass('ct-select-active-menu');
        $fuelSelect.removeClass('ct-select-active-menu');
        $modelSelect.removeClass('ct-select-active-menu');
        $makeSelect.removeClass('ct-select-active-menu');
        $('#ct-search-button').attr('disabled', true);
        $('.ct-main-select-bg .ct-submit-button').removeClass('ct-submit-button-active');
    }

    function updateVariantImages(validVariants) {
        const variantList = validVariants.map(variant => `
            <div class="col-md-12 mb-2">
                <a href="#" data-variant-id="${variant.Value}" class="ct-variant-name" id="ct-vehicle-id">
                    <h4 class="ct-variant-select-heading">${variant.Text}</h4>
                </a>
            </div>
        `).join('');

        const variantHtml = `
                <div class="row ct-fuel-details-row">
                    <div class="col-md-12">
                        <h2 class="my-4 ct-select-title">Please select car variant</h2>
                    </div>
                    ${variantList}
                </div>`;

        $carMakeImages.html(variantHtml).removeClass('ct-container ct-fuel-container').addClass('ct-container ct-fuel-details');
    }

     function fetchVehicles(variantId) {
        $('#loader').show();
        $.ajax({
            url: ct_celtictuning.ajax_url,
            type: 'POST',
            data: { action: 'fetch_vehicles', variant_id: variantId},
            success: function(response) {
                $('#loader').hide();
                $('#ct-variant-select').removeClass('ct-select-active-menu');
                updateVehicleSection(response);
            }
        });
    }


function fetchVehicleUrl(variant) {
    const make = $makeSelect.find('option:selected').text().toLowerCase().replace(/ /g, '-');
    const model = $modelSelect.find('option:selected').text().toLowerCase().replace(/[^a-z0-9-]/g, '-').replace(/-+/g, '-'); // Normalize hyphens
    const fuelType = $fuelSelect.find('option:selected').text().toLowerCase().replace(/ /g, '-');
    const variantText = $variantSelect.find('option:selected').text().toLowerCase().replace(/[^a-z0-9-]/g, '-').replace(/-+/g, '-'); // Normalize hyphens
    const modelText = model.endsWith('-') ? model.slice(0, -1) : model;
    const staticText = 'ECU-remap-chiptuning';
    const baseUrl = ct_celtictuning.rootPageUrl;
    const newUrl = `${baseUrl}${make}/${modelText}/${fuelType}/${variantText}${staticText}/`;
  //  window.history.pushState({ path: newUrl }, '', newUrl);
    window.location.href = newUrl;
}

});