jQuery(document).ready(function($) {

    function showError(fieldName) {
        $(`#error-${fieldName}`).addClass('ct-show-error');
    }

    function hideErrors() {
        $('.ct-error').removeClass('ct-show-error');
    }

    $(document).on('click', '#next-button', function(e) {

        const submitButton = $('.submitButton');
        submitButton.prop('disabled', true);

         setTimeout(function() {
             submitButton.prop('disabled', false);
         }, 5000);
        e.preventDefault();

        const vehicleYear = $('select[name="vehicleYear"]').val();
        const tuningStageSelected = $('input[name="tuningStageId"]:checked').length > 0;
        const selectedTuningStage = $('input[name="tuningStageId"]:checked').val();  // Get the selected tuning stage value
        const additionalOptionSelected = $('input[name="additional_options[]"]:checked').length > 0;  // Check if any additional option is selected


        hideErrors();

        let isValid = true;
        if (!vehicleYear) {
            showError('vehicleYear');
            isValid = false;
        }
        if (!tuningStageSelected) {
            showError('tuningStageId');
            isValid = false;
        }
        if (selectedTuningStage === 'standard' && !additionalOptionSelected) {
            showError('additional_options');
            isValid = false;
        }

        if (isValid) {
            $('#nav-button-2').tab('show');
            $('.ct-contact-label').addClass('active');
            $('.ct-option-label').removeClass('active');
        }
    });

    $(document).on('click', '#back-button', function(e) {
        e.preventDefault();
        $('#nav-button-1').tab('show');
        $('.ct-contact-label').removeClass('active');
        $('.ct-option-label').addClass('active');
    });

    $(document).on('keypress','#requestQuoteForm', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    })

    function isValidEmail(email) {
        const emailPattern = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
        return emailPattern.test(email);
    }

    $(document).on('click', '.submitButton', function(e) {
        e.preventDefault();

            const honeypotValue = $('input[name="first_name"]').val().trim();
            if (honeypotValue !== '') {
                $('#requestQuoteForm .alert').remove();
                $('#requestQuoteForm').prepend('<div class="alert alert-danger" role="alert">Oops! Invalid Details, Please Provide Valid Information.</div>');
                return;
            }

            const formStartTime = parseInt($('#formStartTime').val());
            const currentTime = Math.floor(Date.now() / 1000);

            if (currentTime - formStartTime < 5) {
                $('#requestQuoteForm .alert').remove();
                $('#requestQuoteForm').prepend('<div class="alert alert-danger" role="alert">Oops! Invalid Details, Please Provide Valid Information.</div>');
                return;
            }

        hideErrors();
        let allFieldsFilled = true;
        let firstErrorField = null;

        ['customerName', 'postCode', 'consent', 'accept','address','city','state'].forEach(field => {
            const fieldValue = $(`input[name="${field}"]`).val().trim();
            if (!fieldValue) {
                showError(field);
                allFieldsFilled = false;
                if (!firstErrorField) firstErrorField = $(`input[name="${field}"]`);
            } else if (field === 'email' && !isValidEmail(fieldValue)) {
                showError('email');
                allFieldsFilled = false;
                if (!firstErrorField) firstErrorField = $(`input[name="${field}"]`);
            }
        });

        const email = $('input[name="email"]').val().trim();
        const telephone = $('input[name="telephone"]').val().trim();

        if (!email && !telephone) {
            showError('email');
            showError('telephone');
            allFieldsFilled = false;
            if (!firstErrorField) firstErrorField = $('input[name="email"]');
        } else if (email && !isValidEmail(email)) {
            showError('email');
            allFieldsFilled = false;
            if (!firstErrorField) firstErrorField = $('input[name="email"]');
        }

        const consentChecked = $('.consent').is(':checked');
        const acceptChecked = $('.accept').is(':checked');

        if (!consentChecked) {
            $('.consentText').addClass('ct-show-error');
            allFieldsFilled = false;
            if (!firstErrorField) firstErrorField = $('.consent');
        } else {
            $('.consentText').removeClass('ct-show-error');
        }

        if (ct_celtictuning.termsReq == 'true' && !acceptChecked) {
            $('.agreeText').addClass('ct-show-error');
            allFieldsFilled = false;
            if (!firstErrorField) firstErrorField = $('.accept');
        } else {
            $('.agreeText').removeClass('ct-show-error');
        }

        if (allFieldsFilled) {
            const formData = $('#requestQuoteForm').serializeArray();
            const dataObject = {};
            formData.forEach(function(item) {
                dataObject[item.name] = item.value;
            });

            dataObject.action = 'ct_submit_quote';

            const tuningStageRadio = $('input[name="tuningStageId"]:checked');
            dataObject.tuningStage = tuningStageRadio.val();

            dataObject.tuningStageId = tuningStageRadio.data('tuningstageid');
            dataObject.additionalOptions = $('input[name="additional_options[]"]:checked').map(function() {
                return this.value;
            }).get().join(', ');

            dataObject.selectedOptions = [];
            $('input[name="additional_options[]"]:checked').each(function() {
                const optionKey = $(this).data('additionaloptionkey');
                dataObject.selectedOptions.push({
                    optionKey: optionKey,
                    isChecked: this.checked
                });
            });


            dataObject.alladditionalOptions = {};
            $('input[name="additional_options[]"]').each(function() {
                const optionValue = this.value;
                dataObject.alladditionalOptions[optionValue] = this.checked;
            });

            const submitButton = $(this);
            submitButton.text('Processing...').prop('disabled', true);

            $('#loader').show();
            $.ajax({
                url: ct_celtictuning.ajax_url,
                method: 'POST',
                data: dataObject,
                success: function(response) {
                $('#loader').hide();
                    if (response.success) {
                        $('#requestQuoteForm').html('<div class="alert alert-success" role="alert">' + response.data + '</div>');
                        $('.request-nav').hide();
                    } else {
                        $('#requestQuoteForm .alert').remove();
                        $('#requestQuoteForm').prepend('<div class="alert alert-danger" role="alert">' + response.data.message + '</div>');
                    }

                    submitButton.text('Submit').prop('disabled', false);
                },
                error: function(xhr, status, error) {
                $('#loader').hide();
                let errorMessage = 'There was an error submitting the form. Please try again.';

                if (xhr.status === 403) {
                    const response = JSON.parse(xhr.responseText);
                    if (response && response.data && response.data.message) {
                        errorMessage = response.data.message;
                        $('#requestQuoteForm .alert').remove();
                        $('#requestQuoteForm').prepend('<div class="alert alert-danger" role="alert">' + errorMessage + '</div>');
                    }
                }else{
                    alert(errorMessage);
                }
                    submitButton.text('Submit').prop('disabled', false);
                }
            });


        } else if (firstErrorField) {
            firstErrorField.focus();
        }
    });


});
