jQuery(document).ready(function($) {

    const $makeSelect = $('#ct-make-select-option');
    const $modelSelect = $('#ct-model-select-option');
    const $fuelSelect = $('#ct-fuel-select-option');
    const $variantSelect = $('#ct-variant-select-option');

    $(document).on('change', '#ct-make-select-option', function() {
        fetchModels($(this).val());
    });

    $variantSelect.on('change', function() {
        const selectedOption = $(this).find('option:selected');
        const variantId = selectedOption.val();

        $('#ct-search-button-option').attr('data-button-variant-id', variantId);

        if (variantId) {
            $('#ct-search-button-option').removeAttr('disabled');
        } else {
            $('#ct-search-button-option').attr('disabled', true);
        }
        $('.ct-main-select-bg-shortcode .ct-submit-button').addClass('ct-submit-button-active');

    });

    $(document).on('click', '#ct-search-button-option', function() {
        var variantId = $(this).attr('data-button-variant-id');

        var customPageId = ct_celtictuning.customPageId;
        var siteUrl = ct_celtictuning.siteUrl;

        fetchVehicleUrlShortcode(variantId);
    });

    function getUrlParameters() {
        const urlPath = window.location.pathname;
        const pathParts = urlPath.split('/').filter(part => part);
        const rootPageSlug = ct_celtictuning.rootPageSlug;

        const rootPageIndex = pathParts.indexOf(rootPageSlug);

        if (rootPageIndex === -1) {
            return {}; //
        }

        return {
            makeName: pathParts[rootPageIndex + 1] || undefined,
            modalName: pathParts[rootPageIndex + 2] || undefined,
            fuelName: pathParts[rootPageIndex + 3] || undefined,
            variantName: pathParts[rootPageIndex + 4] || undefined
        };
    }


    function populateSelects(data) {
        const makeOptions = data.makes
            .filter(make => make.Value !== "-1")
            .map(make => {
                const isSelected = make.Value === data.vehicle_data.MakeId ? 'selected' : '';
                return `<option value="${make.Value}" ${isSelected}>${make.Text}</option>`;
            }).join('');

        $makeSelect.html(`<option value="">Select Make</option>${makeOptions}`);
        $makeSelect.removeClass('ct-select-disabled');

        const modelOptions = data.models
            .filter(model => model.Value !== "-1")
            .map(model => {
                const isSelected = model.Value === data.vehicle_data.ModelId ? 'selected' : '';
                return `<option value="${model.Value}" ${isSelected}>${model.Text}</option>`;
            }).join('');

        $modelSelect.html(`<option value="">Select Model</option>${modelOptions}`);
        $modelSelect.removeClass('ct-select-disabled');

        const fuelOptions = data.fuels
            .filter(fuel => fuel.Value !== "-1")
            .map(fuel => {
                const isSelected = String(fuel.Value) === String(data.vehicle_data.FuelType) ? 'selected' : '';
                return `<option data-model-id="${data.vehicle_data.ModelId}" value="${fuel.Value}" ${isSelected}>${fuel.Text}</option>`;
            }).join('');

        $fuelSelect.html(`<option value="">Select Fuel</option>${fuelOptions}`);
        $fuelSelect.removeClass('ct-select-disabled');

        const variantOptions = data.variants
            .filter(variant => variant.Value !== "-1")
            .map(variant => {
                const isSelected = variant.Value === data.vehicle_data.VariantId ? 'selected' : '';
                return `<option value="${variant.Value}" ${isSelected}>${variant.Text}</option>`;
            }).join('');

        $variantSelect.html(`<option value="">Select Variant</option>${variantOptions}`);
        $variantSelect.removeClass('ct-select-disabled');
            $('#ct-search-button-option').removeAttr('disabled');
            $('.ct-main-select-bg-shortcode .ct-submit-button').addClass('ct-submit-button-active');
            $('#ct-search-button-option').attr('data-button-variant-id', data.vehicle_data.VariantId);

    }



    function fetchModels(makeId) {
        $('#loader_shortcode').show();
        $.ajax({
            url: ct_celtictuning.ajax_url,
            type: 'POST',
            data: { action: 'fetch_models', make_id: makeId },
            success: function(response) {
                $('#loader_shortcode').hide();
                const validModels = response.filter(model => model.Value !== "-1");
                const modelOptions = validModels.map(model =>
                    `<option value="${model.Value}">${model.Text}</option>`
                ).join('');
                $('#ct-model-select-option').html(`<option value="">Select a model</option>${modelOptions}`);
                $modelSelect.removeClass('ct-select-disabled');
                $modelSelect.addClass('ct-select-active-menu');
                $makeSelect.removeClass('ct-select-active-menu');
                $fuelSelect.removeClass('ct-select-active-menu');
                $variantSelect.removeClass('ct-select-active-menu');
                $fuelSelect.html(`<option value="">Select Previous</option>`).addClass('ct-select-disabled');
                $variantSelect.html(`<option value="">Select Previous</option>`).addClass('ct-select-disabled');
                $('#ct-search-button-option').attr('disabled', true); // Keep it disabled if no valid option is selected
                $('.ct-main-select-bg-shortcode .ct-submit-button').removeClass('ct-submit-button-active');
            },
            error: function() {
                $('#loader_shortcode').hide();
                alert('Error fetching models');
            }
        });
    }

    $(document).on('change', '#ct-model-select-option', function() {
        fetchFuels($(this).val());
    });

    function fetchFuels(modelId) {
        $('#loader_shortcode').show();
        $.ajax({
            url: ct_celtictuning.ajax_url,
            type: 'POST',
            data: { action: 'fetch_fuels', model_id: modelId },
            success: function(response) {
                $('#loader_shortcode').hide();
                const validFuels = response.filter(fuel => fuel.Value !== "-1");
                const fuelOptions = validFuels.map(fuel =>
                    `<option data-model-id="${modelId}" value="${fuel.Value}">${fuel.Text}</option>`
                ).join('');
                $fuelSelect.html(`<option value="">Select a fuel type</option>${fuelOptions}`);
                $fuelSelect.removeClass('ct-select-disabled');
                $fuelSelect.addClass('ct-select-active-menu');
                $modelSelect.removeClass('ct-select-active-menu');
                $makeSelect.removeClass('ct-select-active-menu');
                $variantSelect.removeClass('ct-select-active-menu');
                $variantSelect.html(`<option value="">Select Previous</option>`).addClass('ct-select-disabled');
                $('#ct-search-button-option').attr('disabled', true); // Keep it disabled if no valid option is selected
                $('.ct-main-select-bg-shortcode .ct-submit-button').removeClass('ct-submit-button-active');
            },
            error: function() {
                $('#loader_shortcode').hide();
                alert('Error fetching fuels');
            }
        });
    }

    // Event delegation for fuel select
    $(document).on('change', '#ct-fuel-select-option', function() {
        const selectedOption = $(this).find('option:selected');
        fetchVariant(selectedOption.val(), selectedOption.data('model-id'));
    });

    function fetchVariant(fuelId, modelId) {
        $('#loader_shortcode').show();
        $.ajax({
            url: ct_celtictuning.ajax_url,
            type: 'POST',
            data: { action: 'fetch_varients', fuel_id: fuelId, model_id: modelId },
            success: function(response) {
                $('#loader_shortcode').hide();
                if (!Array.isArray(response)) {
                    console.error("Expected an array but got:", response);
                    return;
                }

                const validVariants = response.filter(variant => variant.Value !== "-1");
                const variantOptions = validVariants.map(variant =>
                    `<option value="${variant.Value}">${variant.Text}</option>`
                ).join('');

                $variantSelect.html(`<option value="">Select a variant</option>${variantOptions}`);
                $variantSelect.removeClass('ct-select-disabled');
                $variantSelect.addClass('ct-select-active-menu');
                $fuelSelect.removeClass('ct-select-active-menu');
                $modelSelect.removeClass('ct-select-active-menu');
                $makeSelect.removeClass('ct-select-active-menu');
                $('#ct-search-button-option').attr('disabled', true);
                $('.ct-main-select-bg-shortcode .ct-submit-button').removeClass('ct-submit-button-active');
            },
            error: function() {
                $('#loader_shortcode').hide();
                alert('Error fetching variants');
            }
        });
    }

    function fetchVehicleUrlShortcode(variant) {

        const make = $makeSelect.find('option:selected').text().toLowerCase().replace(/ /g, '-');
        const model = $modelSelect.find('option:selected').text().toLowerCase().replace(/[^a-z0-9-]/g, '-').replace(/-+/g, '-'); // Normalize hyphens
        const fuelType = $fuelSelect.find('option:selected').text().toLowerCase().replace(/ /g, '-');
        const variantText = $variantSelect.find('option:selected').text().toLowerCase().replace(/[^a-z0-9-]/g, '-').replace(/-+/g, '-'); // Normalize hyphens
        const modelText = model.endsWith('-') ? model.slice(0, -1) : model;

        // Append the static text
        const staticText = 'ECU-remap-chiptuning';

        const baseUrl = ct_celtictuning.rootPageUrl;
        const newUrl = `${baseUrl}${make}/${modelText}/${fuelType}/${variantText}${staticText}/`;
        window.location.href = newUrl;

            $.ajax({
                url: ct_celtictuning.ajax_url,
                type: 'POST',
                data: {
                    action: 'vehicle_url',
                    variant: variant,
                    make: make
                },
                success: function(response) {
                    // Handle success if needed
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', error);
                }
            });
        }
});
