jQuery(document).ready(function($) {



    insertDynoChartModal();



    const $carMakeImages = $('#car-make-images');





    window.updateVehicleSection =function updateVehicleSection(validVehicles) {

        const additionalOptionsAlt = "Where applicable we are able to switch off the software functionality and monitoring for the Exhaust Gas Recirculation valve enabling it to be blanked off. For more information please refer to our section on EGR Removal.";



        const blockOptions = {

            dpfGranted: ct_celtictuning.dpfGranted,

            egrGranted: ct_celtictuning.egrGranted,

            VMaxRemoval: ct_celtictuning.VMaxRemoval,

            AdBlueRemoval: ct_celtictuning.AdBlueRemoval,

            SwirlFlapsRemoval: ct_celtictuning.SwirlFlapsRemoval,

            O2Removal: ct_celtictuning.O2Removal,

            ColdStartRemoval: ct_celtictuning.ColdStartRemoval,

            ExhaustFlapRemoval: ct_celtictuning.ExhaustFlapRemoval,

            GPFRemoval: ct_celtictuning.GPFRemoval,

            Immobiliser: ct_celtictuning.Immobiliser,

            LaunchControl: ct_celtictuning.LaunchControl,

            RevLimiterRemoval: ct_celtictuning.RevLimiterRemoval,

            StopStartRemoval: ct_celtictuning.StopStartRemoval

        };

        if (window.location.href.indexOf('/request/') > -1) {

            let vehicleHtml = `

    <div class="details-section">

      <div class="ct-container">

          <div class="row">

              <div class="col-md-12 mt-5 mb-3">

                  <picture>

                      <source srcset="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.webp" type="image/webp">

                      <source srcset="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.png" type="image/jpeg">

                      <img class="ct-section-top-logo" src="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.jpg" alt="Celtic Tuning Logo">

                  </picture>

              </div>

              <div class="col-md-12 text-center">

                  <h2 class="ct-car-name">REQUEST</h2>

                  <h2 class="ct-car-model">A QUOTE</h2>

              </div>

          </div>

      </div>

      <div class="ct-container ct-car-details my-5">

          <div class="row">

              <div class="col-lg-6">

                  <div class="ct-main-image">

                      <div class="ct-image-section-part">

                          <picture>

                              <img class="ct-image-main-part" src="${validVehicles.VehicleModelImageUrl}" alt="${validVehicles.ModelName}">

                          </picture>

                      </div>

                      <div class="ct-car-feature-detail">

                          <div class="row mr-0 ml-0 pt-2 py-3 ct-car-row">

                              <div class="col-5 pl-4 text-left">

                                  <h6 class="ct-heading-name">MODEL:</h6>

								  <h5 class="ct-details-name">${validVehicles.MakeName} ${validVehicles.ModelName}</h5>

                              </div>

                              <div class="col-7 pl-5 text-left">

                                  <h6 class="ct-heading-name">VARIANT:</h6>

                                  <h5 class="ct-details-name">${validVehicles.VariantName}</h5>

                              </div>

                          </div>



                          <div class="row mr-0 ml-0 pt-2 py-3 ct-car-row">

                              <div class="col-5 pl-4 text-left">

                                  <h6 class="ct-heading-name">YEARS:</h6>

                                  <h5 class="ct-details-name">

                                   ${validVehicles.VariantFromYear !== null && validVehicles.VariantFromYear !== undefined ? validVehicles.VariantFromYear : 'N/A'} -

                                  ${validVehicles.VariantToYear !== null && validVehicles.VariantToYear !== undefined ? validVehicles.VariantToYear : 'N/A'}

                                  </h5>

                              </div>

                              <div class="col-7 pl-5 text-left">

                                  <h6 class="ct-heading-name">ENGINE SIZE:</h6>

                                  <h5 class="ct-details-name">${validVehicles.EngineCC} CCM</h5>

                              </div>

                          </div>



                          <div class="row mr-0 ml-0 pt-2 py-3 ct-car-row">

                              <div class="col-5 pl-4 text-left">

                                  <h6 class="ct-heading-name">FUEL:</h6>

                                  <h5 class="ct-details-name">${validVehicles.Fuel}</h5>

                              </div>

                              <div class="col-7 pl-5 text-left">

                                  <h6 class="ct-heading-name">ECU TYPE:</h6>

                                  <h5 class="ct-details-name">${validVehicles.ECUType}</h5>

                              </div>

                          </div>

                      </div>

                  </div>

              </div>



          `;



            vehicleHtml += insertRequestQuoteModel(validVehicles);

            vehicleHtml += `</div></div>`;

            $carMakeImages.html(vehicleHtml).removeClass('ct-container ct-fuel-container').addClass('ct-container ct-vehicle-details');

            return;

        }





    let vehicleHtml = `

      <div class="details-section">

    <div class="ct-container">

        <div class="row">

            <div class="col-md-12 mt-5 mb-3">

                <picture>

                    <source srcset="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.webp" type="image/webp">

                    <source srcset="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.png" type="image/jpeg">

                    <img class="ct-section-top-logo" src="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.jpg" alt="Celtic Tuning Logo">

                </picture>

            </div>

            <div class="col-md-12 text-center">

                <h2 class="ct-car-name">${validVehicles.MakeName}</h2>

                <h2 class="ct-car-model">${validVehicles.ModelAndPlatformName}</h2>

                <h3 class="ct-car-feature ct-car-name">[${validVehicles.VariantName}] | ECU Remap | Chiptuning]</h3>

            </div>

        </div>

    </div>

    <div class="ct-container ct-car-details my-5">

        <div class="row">

            <div class="col-lg-6">

                <div class="ct-main-image">

                    <div class="ct-image-section-part">

                        <picture>

                            <img class="ct-image-main-part" src="${validVehicles.VehicleModelImageUrl}" alt="${validVehicles.ModelName}">

                        </picture>

                    </div>

                    <div class="ct-car-feature-detail">

                        <div class="row mr-0 ml-0 pt-2 py-3 ct-car-row">

                            <div class="col-5 pl-4 text-left">

                                <h6 class="ct-heading-name">MODEL:</h6>

                                <h5 class="ct-details-name">${validVehicles.ModelName}</h5>

                            </div>

                            <div class="col-7 pl-5 text-left">

                                <h6 class="ct-heading-name">VARIANT:</h6>

                                <h5 class="ct-details-name">${validVehicles.VariantName}</h5>

                            </div>

                        </div>



                        <div class="row mr-0 ml-0 pt-2 py-3 ct-car-row">

                            <div class="col-5 pl-4 text-left">

                                <h6 class="ct-heading-name">YEARS:</h6>

                                <h5 class="ct-details-name">

                                 ${validVehicles.VariantFromYear !== null && validVehicles.VariantFromYear !== undefined ? validVehicles.VariantFromYear : 'N/A'} -

                                ${validVehicles.VariantToYear !== null && validVehicles.VariantToYear !== undefined ? validVehicles.VariantToYear : 'N/A'}

                                </h5>

                            </div>

                            <div class="col-7 pl-5 text-left">

                                <h6 class="ct-heading-name">ENGINE SIZE:</h6>

                                <h5 class="ct-details-name">${validVehicles.EngineCC} CCM</h5>

                            </div>

                        </div>



                        <div class="row mr-0 ml-0 pt-2 py-3 ct-car-row">

                            <div class="col-5 pl-4 text-left">

                                <h6 class="ct-heading-name">FUEL:</h6>

                                <h5 class="ct-details-name">${validVehicles.Fuel}</h5>

                            </div>

                            <div class="col-7 pl-5 text-left">

                                <h6 class="ct-heading-name">ECU TYPE:</h6>

                                <h5 class="ct-details-name">${validVehicles.ECUType}</h5>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="col-lg-6">

                <div class="row">

                    <div class="col-1">

                        <img src="${ct_celtictuning.pluginUrl}assets/images/check-circle.png" class="ct-check-icon" alt="Check"/>

                    </div>

                    <div class="col-11 mb-3">

                        <p>We at Celtic Tuning develop all of our own software in house using the very latest equipment.</p>

                    </div>

                </div>

                <div class="row">

                    <div class="col-1">

                        <img src="${ct_celtictuning.pluginUrl}assets/images/check-circle.png" class="ct-check-icon" alt="Check"/>

                    </div>

                    <div class="col-11 mb-3">

                        <p>

                            All of our software is developed in our purpose built dyno cells running state of the art Dynocom 4WD rolling roads to ensure accuracy in terms of both power delivery and also to ensure fuelling, boost pressures and exhaust gas temperatures (where applicable) are all within tolerance.</p>

                    </div>

                </div>

                <div class="row">

                    <div class="col-1">

                        <img src="${ct_celtictuning.pluginUrl}assets/images/check-circle.png" class="ct-check-icon" alt="Check"/>

                    </div>

                    <div class="col-11 mb-3">

                        <p>We pride ourselves on our ability to achieve maximum power whilst maintaining optimum reliability.</p>                        </div>

                </div>

            </div>



        </div>

    </div>



    <div class="ct-container">

        <div class="row">

            <div class="col-md-12 mt-5 mb-3">

                <picture>

                    <source srcset="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.webp" type="image/webp">

                    <source srcset="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.png" type="image/jpeg">

                    <img class="ct-section-top-logo" src="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.jpg" alt="Celtic Tuning Logo">

                </picture>

            </div>

            <div class="col-md-12 text-center">

                <h2 class="ct-car-name">Performance</h2>

                <h2 class="ct-car-model">STAGES</h2>

            </div>

        </div>

    </div>

`;



 vehicleHtml += `<div class="row mr-0 mr-lg-2">

<div class="col-12 pr-0 ct-performance-stage-container">

    <div class="ct-container">

        <div class="col-12">

            <div class="row">

                <div class="col-md-6 pl-3 pl-md-0 pt-3 stage-links">`;



validVehicles.TuningStages.forEach((stage, index) => {

// Dynamically create stage buttons

let activeClass = stage.DefaultStage ? 'defaultClass' : '';

vehicleHtml += `

    <a class="stageButton ${activeClass} mr-4" id="stage-${stage.TuningStageId}">

        ${stage.TuningStageTitle}

    </a>`;

});

var currentUrl = window.location.href;

var requestUrl = currentUrl + "request/";



vehicleHtml += `</div>

                <div class="col-md-4 col-12 offset-md-2 text-center text-md-none p-0 pr-0">

                    <a id="ct-request-quote" href="${requestUrl}" class="red-gradient red-shadow px-4 mt-4 mt-md-0 px-md-4 mt-lg-1 text-white float-none float-md-right large-show-button-request">

                        REQUEST QUOTE<i class="fa fa-comment" aria-hidden="true"></i>

                    </a>

                </div>

            </div><div id="tuningStageDetails">

            `;



const defaultStage = validVehicles.TuningStages.find(stage => stage.DefaultStage);

if (defaultStage) {

    vehicleHtml += updateLayoutForStage(defaultStage,validVehicles);

}

vehicleHtml += `</div>

<div class="ct-container my-5">

<div class="row">

    <div class="col-md-12 mt-5 mb-3">

        <picture>

            <source srcset="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.webp"

                type="image/webp">

            <source srcset="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.png"

                type="image/jpeg">

            <img class="ct-section-top-logo"

                src="${ct_celtictuning.pluginUrl}assets/images/detils_Logo.jpg"

                alt="Celtic Tuning Logo">

        </picture>

    </div>

    <div class="col-md-12 text-center">

        <h2 class="ct-car-name">ADDITIONAL</h2>

        <h2 class="ct-car-model">OPTIONS</h2>

    </div>

</div>

<div class="row mx-auto">

    <div class="col-md-12 pt-4 ct-additional-options-container text-center">

        ${validVehicles.EgrRemovalAvailable && blockOptions.egrGranted != 'true' ? `<img alt="Where applicable, we can disable the software functionality for the Exhaust Gas Recirculation (EGR) valve, allowing it to be blanked off. Please note this is against highway regulations and can result in a fine if used on public roads." title="Where applicable, we can disable the software functionality for the Exhaust Gas Recirculation (EGR) valve, allowing it to be blanked off. Please note this is against highway regulations and can result in a fine if used on public roads." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/egr-delete.webp">` : ''}

        ${validVehicles.DpfRemovalAvailable && blockOptions.dpfGranted != 'true' ? `<img alt="Where applicable, we can disable the Diesel Particulate Filter (DPF) monitoring, allowing the DPF to be removed. Please be aware that this is against highway regulations and may lead to fines if used on public roads." title="Where applicable, we can disable the Diesel Particulate Filter (DPF) monitoring, allowing the DPF to be removed. Please be aware that this is against highway regulations and may lead to fines if used on public roads." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/dpf-delete.webp">` : ''}

        ${validVehicles.VMaxRemovalAvailable && blockOptions.VMaxRemoval != 'true' ? `<img alt="Where applicable we are able to raise/lower or completely remove the maximum speed limiter from a vehicle." title="Where applicable we are able to raise/lower or completely remove the maximum speed limiter from a vehicle." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/vmax-removal.webp">` : ''}

        ${validVehicles.AdBlueRemovalAvail  && blockOptions.AdBlueRemoval != 'true' ? `<img alt="Where applicable, we can disable AdBlue system functionality, eliminating the need for AdBlue/SCR fluid. Please note that this is against highway regulations and could result in fines if used on public roads." title="Where applicable, we can disable AdBlue system functionality, eliminating the need for AdBlue/SCR fluid. Please note that this is against highway regulations and could result in fines if used on public roads." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/adBlue.webp">` : ''}

        ${validVehicles.SwirlFlapsRemovalAvail  && blockOptions.SwirlFlapsRemoval != 'true' ? `<img alt="Where applicable, we can disable swirl flap monitoring, allowing for their removal to enhance airflow. Please note this is against highway regulations and can result in fines if used on public roads." title="Where applicable, we can disable swirl flap monitoring, allowing for their removal to enhance airflow. Please note this is against highway regulations and can result in fines if used on public roads." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/swirl-flap-delete.webp">` : ''}

        ${validVehicles.O2RemovalAvail  && blockOptions.O2Removal != 'true' ? `<img alt="Where applicable, we can disable the seconday oxygen (O2) sensor monitoring for enhanced exhaust modifications. Please be aware that this is against highway regulations if used on public roads." title="Where applicable, we can disable the seconday oxygen (O2) sensor monitoring for enhanced exhaust modifications. Please be aware that this is against highway regulations if used on public roads." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/02-delete.webp">` : ''}

        ${validVehicles.ColdStartRemovalAvail  && blockOptions.ColdStartRemoval != 'true' ? `<img alt="Where applicable, we can modify or remove the cold start functionality, reducing high RPM at startup for quieter operation." title="Where applicable, we can modify or remove the cold start functionality, reducing high RPM at startup for quieter operation." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/cold-start-delete.webp">` : ''}

        ${validVehicles.ExhaustFlapRemovalAvail  && blockOptions.ExhaustFlapRemoval != 'true' ? `<img alt="Where applicable, we can disable the functionality of exhaust flaps, allowing them to remain open or closed based on preference." title="Where applicable, we can disable the functionality of exhaust flaps, allowing them to remain open or closed based on preference." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/flapexhaust.webp">` : ''}

        ${validVehicles.GPFRemovalAvail  && blockOptions.GPFRemoval != 'true' ? `<img alt="Where applicable, we can disable the Gasoline Particulate Filter (GPF) monitoring, enabling it to be removed for performance modifications. Please be aware that this is against highway regulations if used on public roads." title="Where applicable, we can disable the Gasoline Particulate Filter (GPF) monitoring, enabling it to be removed for performance modifications. Please be aware that this is against highway regulations if used on public roads." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/gpf-delete.webp">` : ''}

        ${validVehicles.ImmobiliserAvailable  && blockOptions.Immobiliser != 'true' ? `<img alt="Where applicable, we can disable or remove the immobiliser system." title="Where applicable, we can disable or remove the immobiliser system." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/immo-delete.webp">` : ''}

        ${validVehicles.LaunchControlAvailable  && blockOptions.LaunchControl != 'true' ? `<img alt="Where applicable, we can install or adjust launch control in the software, providing fixed RPM launches for faster acceleration and improved sprint times." title="Where applicable, we can install or adjust launch control in the software, providing fixed RPM launches for faster acceleration and improved sprint times." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/launch-control.webp">` : ''}

        ${validVehicles.RevLimiterRemovalAvailable  && blockOptions.RevLimiterRemoval != 'true' ? `<img alt="Where applicable, we can adjust or remove the RPM limiter, providing a broader RPM range for enhanced performance on both petrol and diesel engines." title="Where applicable, we can adjust or remove the RPM limiter, providing a broader RPM range for enhanced performance on both petrol and diesel engines." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/rev-limit.webp">` : ''}

        ${validVehicles.StopStartRemovalAvail  && blockOptions.StopStartRemoval != 'true' ? `<img alt="Where applicable, we can disable the stop-start function, providing continuous engine operation without automatic shutoff at stops." title="Where applicable, we can disable the stop-start function, providing continuous engine operation without automatic shutoff at stops." src="${ct_celtictuning.pluginUrl}assets/images/additional-icons/stopstart.webp">` : ''}

    </div>

</div>



</div>

</div>`;

$carMakeImages.html(vehicleHtml).removeClass('ct-container ct-fuel-container').addClass('ct-container ct-vehicle-details');





const defaultModifiedPower = defaultStage.ModifiedPower;

const defaultTorque = defaultStage.ModifiedTorque;



$('.stageButton').on('click', function() {

    $('.stageButton').removeClass('defaultClass');



    const stageId = $(this).attr('id').replace('stage-', '');

    const selectedStage = validVehicles.TuningStages.find(stage => stage.TuningStageId === stageId);



    if (selectedStage) {

        const stageHtml = updateLayoutForStage(selectedStage, validVehicles);



        // For Power

        const modifiedPower = selectedStage.ModifiedPower;

        const powerDifference = modifiedPower - validVehicles.StandardPower;



        $('#tuningStageDetails').html(stageHtml);

        $(this).addClass('defaultClass');

        initializeCircleProgress(powerDifference, 'ct-power');



        // For Torque

        const modifiedTorque = selectedStage.ModifiedTorque;

        const torqueDifference = modifiedTorque - validVehicles.StandardTorque;

        initializeCircleProgress(torqueDifference, 'ct-torque');

    }

    activateVisibleElements();

});



const initialPowerDifference = defaultModifiedPower - validVehicles.StandardPower;

initializeCircleProgress(initialPowerDifference, 'ct-power');





const initialTorqueDifference = defaultTorque - validVehicles.StandardTorque;

initializeCircleProgress(initialTorqueDifference, 'ct-torque');



$('#ct-request-quote').on('click', function() {

    insertRequestQuoteModel(validVehicles);

});





}





function updateLayoutForStage(stage, validVehicles) {



    const PowerDifference = stage.ModifiedPower - validVehicles.StandardPower;

    const TorqueDifference = stage.ModifiedTorque - validVehicles.StandardTorque;



    const chartButtonHtml = stage.DynoChartUrl

    ? `<button data-toggle="modal" data-target="#DynoChartModal" class="chartButton hide performance-stages-buttons" data-image="${stage.DynoChartUrl}">

        <i class="fas fa-chart-pie" aria-hidden="true"></i>

        <p class="performance-stages-button-text">Chart</p>

      </button>`

    : '';



    return `

        <div class="ct-tuning-stage">

            <div class="row mt-4 bg-white mb-3 top-row-stats">

                <div class="col-12 col-md-2 col-xl-1">

                    <div class="row">

                        <div class="col-md-12 power-title ct-power-header">

                            <h4 class="vert-header font-weight-bold">Power (bhp)</h4>

                        </div>

                    </div>

                </div>

                <div class="col-12 col-md-10 col-xl-11 p-0">

                    <div class="row">

                        <div class="col-12 col-md-4 p-2 pl-md-4 text-center">

                            <div class="statWrap">

                                <h6>Original</h6>

                                <div class="progress powerOriginal stepOne">

                                    <div data-power="1000" class="back"></div>

                                    <div data-power="750" class="back back-green"></div>

                                    <div data-power="500" class="back back-black"></div>

                                    <div data-power="250" class="back back-red"></div>

                                    <div class="back-centre">

                                        <span class="powerOriginalValue carStatValues ct-accent-text">${validVehicles.StandardPower}</span>

                                        <p class="text-center ct-accent-text ct-diff">${validVehicles.StandardPowerUnit}</p>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12 col-md-4 p-2 pl-md-3 text-center">

                            <div class="statWrap">

                                <h6>Modified</h6>

                                <div class="progress powerModified stepTwo">

                                <div data-modifiedPower="1000" class="back"></div>

                                <div data-modifiedPower="750" class="back back-green"></div>

                                <div data-modifiedPower="500" class="back back-black"></div>

                                <div data-modifiedPower="250" class="back back-red"></div>

                                    <div class="back-centre">

                                        <span class="powerModifiedValue carStatValues ct-accent-text">${stage.ModifiedPower}</span>

                                        <p class="text-center powerUnitLabel ct-accent-text ct-diff">${stage.ModifiedPowerUnit}</p>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12 col-md-4 p-2 text-center">

                            <div class="statWrap">

                                <h6>Difference</h6>

                                <div class="ct-wrapper ct-power">

                                    <div class="card">

                                        <div class="circle">

                                            <div class="bar"></div>

                                            <div class="box"><span class="ct-accent-text"></span></div>

                                            <p class="text-center mb-0 mt-2 ct-diff ct-accent-text">${validVehicles.StandardPowerUnit}</p>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>



            <div class="row mt-md-1 mt-lg-4 bottom-row-stats bg-white">

                <div class="col-12 col-md-2 col-xl-1">

                    <div class="row">

                        <div class="col-md-12 power-title ct-power-header">

                            <h4 class="vert-header font-weight-bold">Torque (lb/ft)</h4>

                        </div>

                    </div>

                </div>

                <div class="col-12 col-md-10 col-xl-11 p-0">

                    <div class="row">

                        <div class="col-12 col-md-4 p-2 pl-md-4 text-center">

                            <div class="statWrap">

                                <h6>Original</h6>

                                <div class="gaugeCircle stepOne torqueOriginalContainer" style="display: block;">

                                    <div class="back-centre">

                                        <span class="torqueOriginalValue carStatValues ct-accent-text">${validVehicles.StandardTorque}</span>

                                        <p class="text-center mb-0 torqueUnitLabel ct-accent-text">${validVehicles.StandardTorqueUnit}</p>

                                    </div>

                                    <div class="rectContainer torqueOriginal">

                                    <span data-torque="100" class="rect "></span>

                                    <span data-torque="200" class="rect "></span>

                                    <span data-torque="300" class="rect "></span>

                                    <span data-torque="400" class="rect "></span>

                                    <span data-torque="500" class="rect "></span>

                                    <span data-torque="600" class="rect "></span>

                                    <span data-torque="700" class="rect "></span>

                                    <span data-torque="800" class="rect "></span>

                                    <span data-torque="900" class="rect "></span>

                                    <span data-torque="1000" class="rect "></span>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12 col-md-4 p-2 pl-md-3 text-center">

                            <div class="statWrap">

                                <h6>Modified</h6>

                                <div class="gaugeCircle stepTwo torqueModifiedContainer" style="display: block;">

                                    <div class="back-centre">

                                        <span class="torqueModifiedValue carStatValues ct-accent-text">${stage.ModifiedTorque}</span>

                                        <p class="text-center mb-0 ct-accent-text">${stage.ModifiedTorqueUnit}</p>

                                    </div>

                                    <div class="rectContainer torqueModified">

                                    <span data-modifiedtorque="100" class="rect "></span>

                                    <span data-modifiedtorque="200" class="rect "></span>

                                    <span data-modifiedtorque="300" class="rect "></span>

                                    <span data-modifiedtorque="400" class="rect "></span>

                                    <span data-modifiedtorque="500" class="rect "></span>

                                    <span data-modifiedtorque="600" class="rect "></span>

                                    <span data-modifiedtorque="700" class="rect "></span>

                                    <span data-modifiedtorque="800" class="rect "></span>

                                    <span data-modifiedtorque="900" class="rect "></span>

                                    <span data-modifiedtorque="1000" class="rect "></span>

                                    </div>

                                </div>

                            </div>

                        </div>



                        <div class="col-12 col-md-4 p-2 text-center">

                            <div class="statWrap">

                                <h6>Difference</h6>

                                <div class="ct-wrapper ct-torque">

                                    <div class="card">

                                        <div class="circle">

                                            <div class="bar"></div>

                                            <div class="box">

                                                <span class="ct-accent-text"></span>

                                                <p class="text-center mb-0 mt-2 ct-diff ct-accent-text">${stage.ModifiedTorqueUnit}</p>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>



            <div class="row">

                <div class="col-md-12 text-right">

                    ${chartButtonHtml}

                </div>

                ${stage.StageNotes ? `

                    <div class="col-lg-12 mt-4">

                        <div class="stageNotes">

                            <h4>STAGE NOTES</h4>

                            <p>${stage.StageNotes.replace(/<br\s*\/?>/gi, '')}</p>

                        </div>

                    </div>

                ` : ''}

            </div>

        </div>

    `;

}



function initializeCircleProgress(value, targetClass) {

    const options = {

        startAngle: -1.55,

        size: 150,

        value: value / 100,

        fill: { color: fillColor },

        strokeWidth: 6,

    };



    $(`.${targetClass} .bar`).circleProgress(options).on('circle-animation-progress', function (event, progress, stepValue) {

        $(this).parent().find("span").text((stepValue * 100).toFixed(0) + "+");

    });

}





function insertDynoChartModal() {

    const modalHtml = `

        <!-- Modal -->

        <div class="modal fade ct-chart-container" id="DynoChartModal" tabindex="-1" role="dialog" aria-labelledby="DynoChartModalTitle" aria-hidden="true">

            <div class="modal-dialog modal-lg" role="document">

                <div class="modal-content">

                    <div class="modal-body">

                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                            <span aria-hidden="true">&times;</span>

                        </button>

                        <img src="" alt="chart image" class="img-fluid" id="chartImage">

                    </div>

                </div>

            </div>

        </div>

    `;

    $('body').append(modalHtml); // Append modal to the body



    $('#DynoChartModal').on('show.bs.modal', function(event) {

        const button = $(event.relatedTarget);

        const imageUrl = button.data('image');

        $('#chartImage').attr('src', imageUrl);

    });

}



function formatDifference(value) {

    if (value === undefined || value === null) {

        return 'N/A';

    }

    return value > 0 ? `+${value}` : value === 0 ? '0' : value;

}





function insertRequestQuoteModel(requestVehicle) {

    const options = {

        dpfGranted: ct_celtictuning.dpfGranted,

        egrGranted: ct_celtictuning.egrGranted,

        VMaxRemoval: ct_celtictuning.VMaxRemoval,

        AdBlueRemoval: ct_celtictuning.AdBlueRemoval,

        SwirlFlapsRemoval: ct_celtictuning.SwirlFlapsRemoval,

        O2Removal: ct_celtictuning.O2Removal,

        ColdStartRemoval: ct_celtictuning.ColdStartRemoval,

        ExhaustFlapRemoval: ct_celtictuning.ExhaustFlapRemoval,

        GPFRemoval: ct_celtictuning.GPFRemoval,

        Immobiliser: ct_celtictuning.Immobiliser,

        LaunchControl: ct_celtictuning.LaunchControl,

        RevLimiterRemoval: ct_celtictuning.RevLimiterRemoval,

        StopStartRemoval: ct_celtictuning.StopStartRemoval

    };



    const vehicleDetails = {

	makeName: requestVehicle.MakeName,

    modelName: requestVehicle.ModelName,

    variantName: requestVehicle.VariantName,

    variantFromYear: requestVehicle.VariantFromYear !== null && requestVehicle.VariantFromYear !== undefined ? requestVehicle.VariantFromYear : 'N/A',

    variantToYear: requestVehicle.VariantToYear !== null && requestVehicle.VariantToYear !== undefined ? requestVehicle.VariantToYear : 'N/A',

    engineCC: requestVehicle.EngineCC,

    fuel: requestVehicle.Fuel,

    ecuType: requestVehicle.ECUType

};



const vehicleDetailsString = JSON.stringify(vehicleDetails);



    const currentYear = new Date().getFullYear();

    const fromYear = requestVehicle.VariantFromYear || 2000;

    const toYear = requestVehicle.VariantToYear || currentYear;



    let years = [];



    for (let year = fromYear; year <= toYear; year++) {

        years.push(year);

    }



    const yearOptions = years.map(year => `<option value="${year}">${year}</option>`).join('');



       const tuningStages = requestVehicle.TuningStages || [];

       const tuningOptions = tuningStages.map(stage => `

           <label class="control control--checkbox tuningStage">

               <span class="tuningValue">

                   <span class="tuningBHP">${stage.TuningStageTitle} (${stage.ModifiedPower} bhp)</span>

               </span>

               <input class="radio" name="tuningStageId" onclick="activeRadio()" type="radio" value="${stage.TuningStageTitle}" data-tuningstageid="${stage.TuningStageId}">

           </label>

       `).join('');



       const staticNoTuning = `

           <label class="control control--checkbox tuningStage">

               <span class="tuningValue">

                   <span class="tuningBHP">No Tuning</span>

               </span>

               <input class="radio" name="tuningStageId" onclick="activeRadio()" value="standard" type="radio">

           </label>

       `;



        const additionalOptions = [

            { key: 'DpfRemovalAvailable', title: 'DPF Removal', tooltip: 'Where applicable we are able to switch off the software functionality and monitoring for the Diesel Particulate Filter enabling it to be removed from the vehicle.' },

            { key: 'VMaxRemovalAvailable', title: 'VMax Removal', tooltip: 'Where applicable we are able to raise/lower or completely remove the maximum speed limiter from a vehicle.' },

            { key: 'EgrRemovalAvailable', title: 'EGR Removal', tooltip: 'Where applicable we are able to switch off the software functionality and monitoring for the Exhaust Gas Recirculation valve enabling it to be blanked off.' },

            { key: 'AdBlueRemovalAvail', title: 'AdBlue Removal', tooltip: 'Information about AdBlue removal.' },

            { key: 'SwirlFlapsRemovalAvail', title: 'Swirl Flaps Removal', tooltip: 'Information about swirl flaps removal.' },

            { key: 'O2RemovalAvail', title: 'O2 Sensor Removal', tooltip: 'Information about O2 sensor removal.' },

            { key: 'ColdStartRemovalAvail', title: 'Cold Start Removal', tooltip: 'Information about cold start removal.' },

            { key: 'ExhaustFlapRemovalAvail', title: 'Exhaust Flap Removal', tooltip: 'Information about exhaust flap removal.' },

            { key: 'GPFRemovalAvail', title: 'GPF Removal', tooltip: 'Information about GPF removal.' },

            { key: 'ImmobiliserAvailable', title: 'Immobiliser', tooltip: 'Information about immobiliser options.' },

            { key: 'LaunchControlAvailable', title: 'Launch Control', tooltip: 'Information about launch control options.' },

            { key: 'RevLimiterRemovalAvailable', title: 'Rev Limiter Removal', tooltip: 'Information about rev limiter removal.' },

            { key: 'StopStartRemovalAvail', title: 'Stop/Start Removal', tooltip: 'Information about stop/start removal.' }

        ];



        const additionalOptionsHtml = additionalOptions

            .filter(option => {

                if (option.key === 'DpfRemovalAvailable' && options.dpfGranted === "true") {

                    return false;

                }

                if (option.key === 'EgrRemovalAvailable' && options.egrGranted === "true") {

                    return false;

                }

                if (option.key === 'VMaxRemovalAvailable' && options.VMaxRemoval === "true") {

                    return false;

                }

                if (option.key === 'AdBlueRemovalAvail' && options.AdBlueRemoval === "true") {

                    return false;

                }

                if (option.key === 'SwirlFlapsRemovalAvail' && options.SwirlFlapsRemoval === "true") {

                    return false;

                }

                if (option.key === 'O2RemovalAvail' && options.O2Removal === "true") {

                    return false;

                }

                if (option.key === 'ColdStartRemovalAvail' && options.ColdStartRemoval === "true") {

                    return false;

                }

                if (option.key === 'ExhaustFlapRemovalAvail' && options.ExhaustFlapRemoval === "true") {

                    return false;

                }

                if (option.key === 'GPFRemovalAvail' && options.GPFRemoval === "true") {

                    return false;

                }

                if (option.key === 'ImmobiliserAvailable' && options.Immobiliser === "true") {

                    return false;

                }

                if (option.key === 'LaunchControlAvailable' && options.LaunchControl === "true") {

                    return false;

                }

                if (option.key === 'RevLimiterRemovalAvailable' && options.RevLimiterRemoval === "true") {

                    return false;

                }

                if (option.key === 'StopStartRemovalAvail' && options.StopStartRemoval === "true") {

                    return false;

                }

                return requestVehicle[option.key];

            })

            .map(option => `

                <label title="${option.tooltip}" class="control control--checkbox additional_options">

                    <span class="optionBox">${option.title}</span>

                    <input type="checkbox" class="checkbox" name="additional_options[]" onclick="activeCheckbox(this)" value="${option.title}" data-additionaloptionkey="${option.key}">

                </label>

        `).join('');



        const countries = [

            { code: 'AF', name: 'Afghanistan' },

            { code: 'AL', name: 'Albania' },

            { code: 'DZ', name: 'Algeria' },

            { code: 'AS', name: 'American Samoa' },

            { code: 'AD', name: 'Andorra' },

            { code: 'AO', name: 'Angola' },

            { code: 'AI', name: 'Anguilla' },

            { code: 'AQ', name: 'Antarctica' },

            { code: 'AG', name: 'Antigua and Barbuda' },

            { code: 'AR', name: 'Argentina' },

            { code: 'AM', name: 'Armenia' },

            { code: 'AW', name: 'Aruba' },

            { code: 'AU', name: 'Australia' },

            { code: 'AT', name: 'Austria' },

            { code: 'AZ', name: 'Azerbaijan' },

            { code: 'BS', name: 'Bahamas' },

            { code: 'BH', name: 'Bahrain' },

            { code: 'BD', name: 'Bangladesh' },

            { code: 'BB', name: 'Barbados' },

            { code: 'BY', name: 'Belarus' },

            { code: 'BE', name: 'Belgium' },

            { code: 'BZ', name: 'Belize' },

            { code: 'BJ', name: 'Benin' },

            { code: 'BM', name: 'Bermuda' },

            { code: 'BT', name: 'Bhutan' },

            { code: 'BO', name: 'Bolivia' },

            { code: 'BQ', name: 'Bonaire, Sint Eustatius and Saba' },

            { code: 'BA', name: 'Bosnia and Herzegovina' },

            { code: 'BW', name: 'Botswana' },

            { code: 'BV', name: 'Bouvet Island' },

            { code: 'BR', name: 'Brazil' },

            { code: 'IO', name: 'British Indian Ocean Territory' },

            { code: 'BN', name: 'Brunei Darussalam' },

            { code: 'BG', name: 'Bulgaria' },

            { code: 'BF', name: 'Burkina Faso' },

            { code: 'BI', name: 'Burundi' },

            { code: 'CV', name: 'Cabo Verde' },

            { code: 'KH', name: 'Cambodia' },

            { code: 'CM', name: 'Cameroon' },

            { code: 'CA', name: 'Canada' },

            { code: 'KY', name: 'Cayman Islands' },

            { code: 'CF', name: 'Central African Republic' },

            { code: 'TD', name: 'Chad' },

            { code: 'CL', name: 'Chile' },

            { code: 'CN', name: 'China' },

            { code: 'CX', name: 'Christmas Island' },

            { code: 'CC', name: 'Cocos (Keeling) Islands' },

            { code: 'CO', name: 'Colombia' },

            { code: 'KM', name: 'Comoros' },

            { code: 'CG', name: 'Congo' },

            { code: 'CD', name: 'Congo, Democratic Republic of the' },

            { code: 'CK', name: 'Cook Islands' },

            { code: 'CR', name: 'Costa Rica' },

            { code: 'HR', name: 'Croatia' },

            { code: 'CU', name: 'Cuba' },

            { code: 'CW', name: 'Curaçao' },

            { code: 'CY', name: 'Cyprus' },

            { code: 'CZ', name: 'Czech Republic' },

            { code: 'DK', name: 'Denmark' },

            { code: 'DJ', name: 'Djibouti' },

            { code: 'DM', name: 'Dominica' },

            { code: 'DO', name: 'Dominican Republic' },

            { code: 'EC', name: 'Ecuador' },

            { code: 'EG', name: 'Egypt' },

            { code: 'SV', name: 'El Salvador' },

            { code: 'GQ', name: 'Equatorial Guinea' },

            { code: 'ER', name: 'Eritrea' },

            { code: 'EE', name: 'Estonia' },

            { code: 'SZ', name: 'Eswatini' },

            { code: 'ET', name: 'Ethiopia' },

            { code: 'FK', name: 'Falkland Islands (Malvinas)' },

            { code: 'FO', name: 'Faroe Islands' },

            { code: 'FJ', name: 'Fiji' },

            { code: 'FI', name: 'Finland' },

            { code: 'FR', name: 'France' },

            { code: 'GF', name: 'French Guiana' },

            { code: 'PF', name: 'French Polynesia' },

            { code: 'TF', name: 'French Southern Territories' },

            { code: 'GA', name: 'Gabon' },

            { code: 'GM', name: 'Gambia' },

            { code: 'GE', name: 'Georgia' },

            { code: 'DE', name: 'Germany' },

            { code: 'GH', name: 'Ghana' },

            { code: 'GI', name: 'Gibraltar' },

            { code: 'GR', name: 'Greece' },

            { code: 'GL', name: 'Greenland' },

            { code: 'GD', name: 'Grenada' },

            { code: 'GP', name: 'Guadeloupe' },

            { code: 'GU', name: 'Guam' },

            { code: 'GT', name: 'Guatemala' },

            { code: 'GG', name: 'Guernsey' },

            { code: 'GN', name: 'Guinea' },

            { code: 'GW', name: 'Guinea-Bissau' },

            { code: 'GY', name: 'Guyana' },

            { code: 'HT', name: 'Haiti' },

            { code: 'HM', name: 'Heard Island and McDonald Islands' },

            { code: 'VA', name: 'Holy See' },

            { code: 'HN', name: 'Honduras' },

            { code: 'HK', name: 'Hong Kong' },

            { code: 'HU', name: 'Hungary' },

            { code: 'IS', name: 'Iceland' },

            { code: 'IN', name: 'India' },

            { code: 'ID', name: 'Indonesia' },

            { code: 'IR', name: 'Iran' },

            { code: 'IQ', name: 'Iraq' },

            { code: 'IE', name: 'Ireland' },

            { code: 'IM', name: 'Isle of Man' },

            { code: 'IL', name: 'Israel' },

            { code: 'IT', name: 'Italy' },

            { code: 'JM', name: 'Jamaica' },

            { code: 'JP', name: 'Japan' },

            { code: 'JE', name: 'Jersey' },

            { code: 'JO', name: 'Jordan' },

            { code: 'KZ', name: 'Kazakhstan' },

            { code: 'KE', name: 'Kenya' },

            { code: 'KI', name: 'Kiribati' },

            { code: 'KP', name: 'Korea, Democratic People\'s Republic of' },

            { code: 'KR', name: 'Korea, Republic of' },

            { code: 'KW', name: 'Kuwait' },

            { code: 'KG', name: 'Kyrgyzstan' },

            { code: 'LA', name: 'Lao People\'s Democratic Republic' },

            { code: 'LV', name: 'Latvia' },

            { code: 'LB', name: 'Lebanon' },

            { code: 'LS', name: 'Lesotho' },

            { code: 'LR', name: 'Liberia' },

            { code: 'LY', name: 'Libya' },

            { code: 'LI', name: 'Liechtenstein' },

            { code: 'LT', name: 'Lithuania' },

            { code: 'LU', name: 'Luxembourg' },

            { code: 'MO', name: 'Macao' },

            { code: 'MG', name: 'Madagascar' },

            { code: 'MW', name: 'Malawi' },

            { code: 'MY', name: 'Malaysia' },

            { code: 'MV', name: 'Maldives' },

            { code: 'ML', name: 'Mali' },

            { code: 'MT', name: 'Malta' },

            { code: 'MH', name: 'Marshall Islands' },

            { code: 'MQ', name: 'Martinique' },

            { code: 'MR', name: 'Mauritania' },

            { code: 'MU', name: 'Mauritius' },

            { code: 'YT', name: 'Mayotte' },

            { code: 'MX', name: 'Mexico' },

            { code: 'FM', name: 'Micronesia' },

            { code: 'MD', name: 'Moldova' },

            { code: 'MC', name: 'Monaco' },

            { code: 'MN', name: 'Mongolia' },

            { code: 'MS', name: 'Montserrat' },

            { code: 'MA', name: 'Morocco' },

            { code: 'MZ', name: 'Mozambique' },

            { code: 'MM', name: 'Myanmar' },

            { code: 'NA', name: 'Namibia' },

            { code: 'NR', name: 'Nauru' },

            { code: 'NP', name: 'Nepal' },

            { code: 'NL', name: 'Netherlands' },

            { code: 'NC', name: 'New Caledonia' },

            { code: 'NZ', name: 'New Zealand' },

            { code: 'NI', name: 'Nicaragua' },

            { code: 'NE', name: 'Niger' },

            { code: 'NG', name: 'Nigeria' },

            { code: 'NU', name: 'Niue' },

            { code: 'NF', name: 'Norfolk Island' },

            { code: 'MP', name: 'Northern Mariana Islands' },

            { code: 'NO', name: 'Norway' },

            { code: 'OM', name: 'Oman' },

            { code: 'PK', name: 'Pakistan' },

            { code: 'PW', name: 'Palau' },

            { code: 'PS', name: 'Palestine, State of' },

            { code: 'PA', name: 'Panama' },

            { code: 'PG', name: 'Papua New Guinea' },

            { code: 'PY', name: 'Paraguay' },

            { code: 'PE', name: 'Peru' },

            { code: 'PH', name: 'Philippines' },

            { code: 'PN', name: 'Pitcairn' },

            { code: 'PL', name: 'Poland' },

            { code: 'PT', name: 'Portugal' },

            { code: 'PR', name: 'Puerto Rico' },

            { code: 'QA', name: 'Qatar' },

            { code: 'RE', name: 'Réunion' },

            { code: 'RO', name: 'Romania' },

            { code: 'RU', name: 'Russian Federation' },

            { code: 'RW', name: 'Rwanda' },

            { code: 'BL', name: 'Saint Barthélemy' },

            { code: 'KN', name: 'Saint Kitts and Nevis' },

            { code: 'LC', name: 'Saint Lucia' },

            { code: 'MF', name: 'Saint Martin (French part)' },

            { code: 'SX', name: 'Saint Martin (Dutch part)' },

            { code: 'PM', name: 'Saint Pierre and Miquelon' },

            { code: 'VC', name: 'Saint Vincent and the Grenadines' },

            { code: 'WS', name: 'Samoa' },

            { code: 'SM', name: 'San Marino' },

            { code: 'ST', name: 'Sao Tome and Principe' },

            { code: 'SA', name: 'Saudi Arabia' },

            { code: 'SN', name: 'Senegal' },

            { code: 'RS', name: 'Serbia' },

            { code: 'SC', name: 'Seychelles' },

            { code: 'SL', name: 'Sierra Leone' },

            { code: 'SG', name: 'Singapore' },

            { code: 'SX', name: 'Sint Maarten (Dutch part)' },

            { code: 'SK', name: 'Slovakia' },

            { code: 'SI', name: 'Slovenia' },

            { code: 'SB', name: 'Solomon Islands' },

            { code: 'SO', name: 'Somalia' },

            { code: 'ZA', name: 'South Africa' },

            { code: 'GS', name: 'South Georgia and the South Sandwich Islands' },

            { code: 'SS', name: 'South Sudan' },

            { code: 'ES', name: 'Spain' },

            { code: 'LK', name: 'Sri Lanka' },

            { code: 'SD', name: 'Sudan' },

            { code: 'SR', name: 'Suriname' },

            { code: 'SJ', name: 'Svalbard and Jan Mayen' },

            { code: 'SZ', name: 'Sweden' },

            { code: 'CH', name: 'Switzerland' },

            { code: 'SY', name: 'Syrian Arab Republic' },

            { code: 'TW', name: 'Taiwan, Province of China' },

            { code: 'TJ', name: 'Tajikistan' },

            { code: 'TZ', name: 'Tanzania, United Republic of' },

            { code: 'TH', name: 'Thailand' },

            { code: 'TL', name: 'Timor-Leste' },

            { code: 'TG', name: 'Togo' },

            { code: 'TK', name: 'Tokelau' },

            { code: 'TO', name: 'Tonga' },

            { code: 'TT', name: 'Trinidad and Tobago' },

            { code: 'TN', name: 'Tunisia' },

            { code: 'TR', name: 'Turkey' },

            { code: 'TM', name: 'Turkmenistan' },

            { code: 'TC', name: 'Turks and Caicos Islands' },

            { code: 'TV', name: 'Tuvalu' },

            { code: 'UG', name: 'Uganda' },

            { code: 'UA', name: 'Ukraine' },

            { code: 'AE', name: 'United Arab Emirates' },

            { code: 'GB', name: 'United Kingdom' },

            { code: 'US', name: 'United States' },

            { code: 'UM', name: 'United States Minor Outlying Islands' },

            { code: 'VI', name: 'United States Virgin Islands' },

            { code: 'UY', name: 'Uruguay' },

            { code: 'UZ', name: 'Uzbekistan' },

            { code: 'VU', name: 'Vanuatu' },

            { code: 'VE', name: 'Venezuela' },

            { code: 'VN', name: 'Viet Nam' },

            { code: 'WF', name: 'Wallis and Futuna' },

            { code: 'WS', name: 'Western Sahara' },

            { code: 'YE', name: 'Yemen' },

            { code: 'ZM', name: 'Zambia' },

            { code: 'ZW', name: 'Zimbabwe' }

        ];



        const countryOptions = countries.map(country => {

            if (country.code === ct_celtictuning.defaultCountry) {

                return `<option value="${country.code}" selected>${country.name}</option>`;

            } else {

                return `<option value="${country.code}">${country.name}</option>`;

            }

        }).join('');

        const currentTime = Math.floor(Date.now() / 1000);



    const requestModalHtml = `

    <!-- Modal -->

         <div class="col-lg-6 ct-modal-container ct-modal-content">

                    <div class="requestContain">

                        <ul style="display: none" class="nav request-nav nav-tabs mb-4 justify-content-left ml-2" role="tablist">

                            <li class="nav-item">

                                <a class="nav-link px-0 active mr-3" id="nav-button-1" data-toggle="tab" href="#tabs-1" role="tab">SELECT

                              OPTIONS</a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link px-0" id="nav-button-2" data-toggle="tab" href="#tabs-2" role="tab">CONTACT DETAILS</a>

                            </li>

                        </ul>

                        <ul class="nav request-nav nav-tabs mb-4 justify-content-left ml-2 nav-label" role="tablist">

                            <li class="nav-item">

                                <a class="nav-link px-0 active mr-3 ct-option-label disabled active" id="nav-button-1" data-toggle="tab" href="#tabs-1" role="tab">SELECT

                              OPTIONS</a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link px-0 disabled ct-contact-label" id="nav-button-2" data-toggle="tab" href="#tabs-2" role="tab">CONTACT DETAILS</a>

                            </li>

                        </ul>

                        <form id="requestQuoteForm">

                        <input type="hidden" name="varient_id" value="${requestVehicle.VariantId}">

                        <input type="hidden" name="vehicle_details" value='${vehicleDetailsString}'>

                        <input type="hidden" name="security" value="${ct_celtictuning.nonce}">

                        <input type="hidden" name="first_name" autocomplete="off">

                        <input type="hidden" id="formStartTime" name="formStartTime" value="${currentTime}">



                        <div class="tab-content">

                            <div class="tab-pane active" id="tabs-1" role="tabpanel">

                                <div class="row no-gutters">

                                    <div class="col-md-12">

                                        <div class="col-md-5 mt-md-0 mt-3">

                                            <h3 class="ct-quotes-text">VEHICLE YEAR</h3>

                                            <p class="ct-error" id="error-vehicleYear" style="display:none;">* Please select Vehicle Year</p>

                                        </div>

                                        <div class="col-md-8 pl-0">

                                            <div class="fake-select">

                                                <select name="vehicleYear">

                                                    ${yearOptions}

                                                </select>

                                            </div>

                                        </div>

                                        <div class="col-md-12 mt-3">

                                            <h3 class="ct-quotes-text">SELECT TUNING STAGE</h3>

                                            <p class="ct-error" id="error-tuningStageId" style="display:none;">* Please select Tuning Stage</p>

                                        </div>

                                        <div class="col-md-12 pl-0 stage-contain overflow-hidden">

                                            ${staticNoTuning} ${tuningOptions}

                                        </div>

                                        <div class="col-md-12">

                                            <h3 class="ct-quotes-text">SELECT OPTIONS</h3>

                                            <p class="ct-error" id="error-additional_options" style="display:none;">* Please select Options</p>

                                        </div>

                                        <div class="col-md-12 pl-0">

                                            ${additionalOptionsHtml}

                                        </div>

                                    </div>

                                </div>

                                <a id="next-button" data-toggle="tab" href="#tabs-2" role="tab" class="red-gradient next-nav red-shadow pt-2 pt-lg-2 px-4 mt-4 mt-md-3 pt-md-2 px-md-4 text-white float-left show-button" disabled>

                              Next </a>

                            </div>

                            <div class="tab-pane" id="tabs-2" role="tabpanel">

                                <div class="row">

                                    <div class="col-md-12">

                                        <div class="col-md-12 offset-sm-0 col-sm-12">

                                            <div class="row">

                                                <div class="col-lg-6 col-12">

                                                    <div class="fullNameContain">

                                                        <p class="ct-quotes-text">Your Name<span class="ct-error" id="error-customerName" style="display:none;"> * Please Enter Your Name</span></p>

                                                        <input name="customerName" class="fullName" type="text">

                                                        <div class="errorBag"></div>

                                                    </div>

                                                </div>

                                                <div class="col-lg-6 col-12">

                                                    <div class="emailContain">

                                                        <p class="ct-quotes-text">Email<span class="ct-error" id="error-email" style="display:none;"> * Please Enter Valid Email or Telephone</span></p>

                                                        <input name="email" class="email" type="text">

                                                        <div class="errorBag"></div>

                                                    </div>

                                                </div>

                                                <div class="col-lg-6 mt-2 mt-lg-3 col-12">

                                                    <p class="ct-quotes-text">Telephone<span class="ct-error" id="error-telephone" style="display:none;"> * Please Enter Valid Email or Telephone</span></p>

                                                    <input name="telephone" type="text">

                                                </div>

                                                <div class="col-lg-6 col-12 mt-2 mt-lg-3">

                                                    <div class="postcodeContain">

                                                        <p class="ct-quotes-text">Post/Zip Code

                                                            <span class="ct-error" id="error-postCode" style="display:none;"> * Please Enter Your Post/Zip Code</span>

                                                        </p>

                                                        <input type="text" placeholder="Post/Zip Code" class="postcode" name="postCode" id="postcode" value>



                                                        <div class="errorBag"></div>

                                                    </div>

                                                </div>

                                                <div class="col-md-12">

                                                <p class="ct-quotes-text">Address<span class="ct-error" id="error-address" style="display:none;"> * Please Enter Your Address</span></p>

                                                <input name="address" type="text">

                                               </div>

                                               <div class="col-lg-6 mt-2 mt-lg-3 col-12">

                                                <p class="ct-quotes-text">Town/City<span class="ct-error" id="error-city" style="display:none;"> * Please Enter Your Town/City</span></p>

                                                <input name="city" type="text">

                                               </div>

                                               <div class="col-lg-6 mt-2 mt-lg-3 col-12">

                                               <p class="ct-quotes-text">County/State<span class="ct-error" id="error-state" style="display:none;"> * Please Enter Your County/State</span></p>

                                               <input name="state" type="text">

                                               </div>

                                                <div class="col-12 postcodeContainer" style="padding-left: 15px;"><span id="result"></span></div>

                                                <div class="col-lg-6 col-12 mt-2 mt-lg-3 mb-3">

                                                    <p class="ct-quotes-text">Country</p>

                                                    <div class="col-12 fake-select">

                                                        <select id="country" name="country">

                                                         ${countryOptions}

                                                        </select>

                                                    </div>

                                                    <div class="row pt-3 agreement-block">

                                                        <div class="checkboxClick mb-2">

                                                            <div style="display:flex; gap:10px;">

                                                                <div>

                                                                    <div class="fake-checkmark consentCheck pt-1">

                                                                        <label class="request-form-checkbox">

                                                                            <input type="checkbox" name="consent" class="consent ct-checkbox-cursor">

                                                                            <span class="checkmark"></span>

                                                                        </label>

                                                                    </div>

                                                                </div>

                                                                <div class="consentText">

                                                                    I consent to you contacting me for my requested quotations/bookings/ appointments

                                                                </div>

                                                            </div>



                                                        </div>

                                                        <div class="checkboxClick mb-2">

                                                            <div style="display:flex; gap:10px;">

                                                                <div>

                                                                    <div class="fake-checkmark marketingCheck pt-1">

                                                                        <label class="request-form-checkbox">

                                                                            <input type="checkbox" name="marketing" class="marketing ct-checkbox-cursor">

                                                                            <span class="checkmark"></span>

                                                                        </label>

                                                                    </div>

                                                                </div>

                                                                <div>

                                                                    I would like to hear more about Celtic Tuning, Special offers or Last Minute deals

                                                                </div>

                                                            </div>

                                                        </div>

                                                        <div class="checkboxClick mb-2">

                                                            <div style="display:flex; gap:10px;">

                                                                <div>

                                                                    <div class="fake-checkmark  agreeCheck pt-1">

                                                                        <label class="request-form-checkbox">

                                                                            <input type="checkbox" name="accept" class="accept ct-checkbox-cursor">

                                                                            <span class="checkmark"></span>

                                                                        </label>

                                                                    </div>

                                                                </div>

                                                                <div class="agreeText">

                                                                    I have read and agree to the <a target="_blank" href="${ct_celtictuning.termsUrl}">Term &amp; Conditions</a>

                                                                </div>

                                                            </div>

                                                        </div>

                                                    </div>

                                                </div>

                                                <div class="col-lg-6 col-12 mt-2 mt-lg-3">

                                                    <p class="ct-quotes-text">Additional Comments

                                                    </p>

                                                    <textarea class="p-2 ct-additionalComments" name="additionalComments" rows="5" col="50" placeholder="Additional comments or if multiple vehicles quote is required, a list of vehicle registration numbers."></textarea>

                                                </div>

                                            </div>

                                        </div>

                                        <div class="errorBag">

                                            <p class="error"></p>

                                        </div>

                                        <div class="request-button-container px-3 px-md-0 mt-4 ml-lg-0 ct-button">

                                            <a id="back-button" data-toggle="tab" href="#tabs-1" role="tab" class="back-nav ct-form-back-button black-gradient black-shadow text-white float-left mr-3 show-button mb-2">

                                       Back

                                       </a>

                                            <button class="red-gradient ct-form-submit-button submitButton red-shadow px-4 mt-md-0  px-md-4 text-white float-left large-show-button btn-height mb-2">

                                                Submit

                                            </button>

                                            <input type="hidden" name="recaptcha_token" id="recaptcha_token">

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <form>



                    </div>

                </div>



    <div class="modal fade" id="confirmationModal" tabindex="-1" role="dialog" aria-labelledby="confirmationModalLabel" aria-hidden="true" style="opacity: 1 !important; padding-right:0px !important;">

        <div class="modal-dialog" role="document">

            <div class="modal-content">

                <div class="modal-header">

                    <h5 class="modal-title" id="confirmationModalLabel" style="margin-bottom:0px;">Confirmation Required</h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                        <span aria-hidden="true">&times;</span>

                    </button>

                </div>

                <div class="modal-body">

                    <p id="confirmationMessage"></p>

                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>

                    <button type="button" class="btn btn-primary" id="confirmButton">OK</button>

                </div>

            </div>

        </div>

        </div>

    `;

    if(ct_celtictuning.enable_recaptcha_v3 == 'true' && ct_celtictuning.recaptcha_site_key){

        grecaptcha.ready(function() {

            grecaptcha.execute(ct_celtictuning.recaptcha_site_key, {action: 'submit'}).then(function(token) {

                $('#recaptcha_token').val(token);

            });

        });

    }

    return requestModalHtml;

    $('#modalContainer').html('');



    $('#modalContainer').html(requestModalHtml);



}



$(window).on('scroll', function() {

    activateVisibleElements();

});



function activateVisibleElements() {



    $('.powerOriginal').each(function() {

        var value = parseInt($(this).find(".powerOriginalValue").text(), 10);

        if ($(this).visible(true)) {

            activatePower(this, value, 'powerOriginal');

        }

    });



    $('.powerModified').each(function() {

        var value = parseInt($(this).find(".powerModifiedValue").text(), 10);

        if ($(this).visible(true)) {

            activatePower(this, value, 'powerModified');

        }

    });



    $('.torqueOriginalContainer').each(function() {

        var value = parseInt($(this).find(".torqueOriginalValue").text(), 10);

        if ($(this).visible(true)) {

            activateTorque(this, value, 'torqueOriginalValue');

        }

    });



    $('.torqueModifiedContainer').each(function() {

        var value = parseInt($(this).find(".torqueModifiedValue").text(), 10);

        if ($(this).visible(true)) {

            activateTorque(this, value, 'torqueModifiedValue');

        }

    });

}



$.fn.visible = function(partial) {

    var $t = $(this),

        $w = $(window),

        viewTop = $w.scrollTop(),

        viewBottom = viewTop + $w.height(),

        top = $t.offset().top,

        bottom = top + $t.height(),

        compareTop = partial === true ? bottom : top,

        compareBottom = partial === true ? top : bottom;

    return ((compareBottom <= viewBottom) && (compareTop >= viewTop));

};



function activatePower(section, value, sectionType) {

    const powerDivs = $(section).find('.back');

    const rects = $(section).find('.rect');

    const dataAttribute = sectionType === 'powerOriginal' ? 'data-power' : 'data-modifiedpower';



    let numActiveCircles = 0;



    if (value <= 250) {

        numActiveCircles = 1;

    } else if (value <= 500) {

        numActiveCircles = 2;

    } else if (value <= 750) {

        numActiveCircles = 3;

    } else {

        numActiveCircles = 4;

    }



    if(dataAttribute == 'data-modifiedpower'){

        numActiveCircles = numActiveCircles + 1;

    }



    powerDivs.toArray().reverse().forEach((circle, index) => {

        setTimeout(() => {

            const powerValue = parseInt($(circle).attr(dataAttribute), 10);

            if (index < numActiveCircles) {

                $(circle).addClass('chartActive');

            } else {

                $(circle).removeClass('chartActive');

            }

        }, index * 300);

    });



}



function activateTorque(section, value, sectionType) {

    const rect = $(section).find('.rect');

    const dataAttribute = sectionType === 'torqueOriginalValue' ? 'data-torque' : 'data-modifiedtorque';



    let numActiveCircles = 0;

    if (value <= 100) {

        numActiveCircles = 1;

    } else if (value <= 200) {

        numActiveCircles = 2;

    } else if (value <= 300) {

        numActiveCircles = 3;

    } else if (value <= 400) {

        numActiveCircles = 4;

    } else if (value <= 500) {

        numActiveCircles = 5;

    } else if (value <= 600) {

        numActiveCircles = 6;

    } else if (value <= 700) {

        numActiveCircles = 7;

    } else if (value <= 800) {

        numActiveCircles = 8;

    } else if (value <= 900) {

        numActiveCircles = 9;

    } else {

        numActiveCircles = 10;

    }



    if(dataAttribute == 'data-modifiedtorque'){

        numActiveCircles = numActiveCircles + 2;

   // console.log('numActiveCircles-----', numActiveCircles);



    }



    rect.toArray().forEach((circle, index) => {

        setTimeout(() => {

            const powerValue = parseInt($(circle).attr(dataAttribute), 10);

            if (index < numActiveCircles) {

                $(circle).addClass('rectActive');

            } else {

                $(circle).removeClass('rectActive');

            }

        }, index * 300);

    });

}





});



