<?php

/*

Plugin Name: Celtic Tuning

Description: A plugin to integrate Celtic Tuning API and allow selection of car makes and models.

Version: 1.0

Author: Celtic Tuning

*/



require_once plugin_dir_path(__FILE__) . 'includes/ct-settings-page.php';

require_once plugin_dir_path(__FILE__) . 'includes/ct-api-functions.php'; 

require_once plugin_dir_path(__FILE__) . 'includes/ct-frontend-display.php'; 

require_once plugin_dir_path(__FILE__) . 'includes/ct-vehicle-form-shortcode.php'; 

require_once plugin_dir_path(__FILE__) . 'includes/ct-view-quote-requests.php';



/**

 * Adds ct-Celtictuning plugin menus to the admin dashboard.

 * 

 * @since 1.0

 */

function ct_celtictuning_menu() {

    add_menu_page('ct-Celtictuning Settings', 'Celtic Tuning', 'manage_options', 'ct_celtictuning', 'ct_celtictuning_settings_page', 'dashicons-admin-generic', 100);

    add_submenu_page('ct_celtictuning', 'Settings', 'Settings', 'manage_options', 'ct_celtictuning_settings', 'ct_celtictuning_settings_page');

    add_submenu_page('ct_celtictuning', 'View Quote Requests', 'View Quote Requests', 'manage_options', 'ct_view_quote_requests', 'ct_view_quote_requests_page');

    remove_submenu_page('ct_celtictuning', 'ct_celtictuning');

}

add_action('admin_menu', 'ct_celtictuning_menu');



/**

 * Enqueues scripts and styles only on the root & shortcode page specified in the plugin settings.

 * 

 * @since 1.0

 */

function ct_celtictuning_enqueue_scripts_conditionally() {

    $root_page = get_option('ct_celtictuning_settings');

    if (!is_array($root_page)) {

        return;

    }

    $is_root_page = is_page($root_page['rootpage']);

    $post_content = get_post(get_the_ID())->post_content;

    $is_shortcode_page = has_shortcode($post_content, 'celtic_vehicle_form');

    

    //if ($is_root_page || $is_shortcode_page) {

        enqueue_ct_scripts();

    //}

}



/**

 * Enqueues scripts and styles.

 * 

 * @since 1.0

 */

function enqueue_ct_scripts() {

        wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css', array(), '4.6.2', 'all');

        wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css', array(), '6.6.0', 'all');

        wp_enqueue_style('round-slider-css', 'https://cdn.jsdelivr.net/npm/round-slider@1.6.1/dist/roundslider.min.css', array(), '1.6.1', 'all');

        wp_enqueue_style('ct-celtictuning-style', plugins_url('assets/css/style.css', __FILE__), array(), null, 'all');

        wp_enqueue_style('ct-celtictuning-responsive', plugins_url('assets/css/responsive.css', __FILE__), array(), null, 'all');



        wp_enqueue_script('jquery');

        wp_enqueue_script('jquery-js', 'https://code.jquery.com/jquery-3.6.0.min.js', array('jquery'), '4.6.2', true);

        wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js', array('jquery'), '4.6.2', true);

        wp_enqueue_script('round-slider-js', 'https://cdnjs.cloudflare.com/ajax/libs/roundSlider/1.6.1/roundslider.min.js', array('jquery'), '1.6.1', true);

        wp_enqueue_script('jquery-circle-progress', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-circle-progress/1.2.2/circle-progress.min.js', array('jquery'), null, true);

        wp_enqueue_script('update-vehicle-section', plugins_url('assets/js/ct-updateVehicleSection.js', __FILE__), array('jquery'), null, true);

        wp_enqueue_script('ct-request-quote', plugins_url('assets/js/ct-request-quote.js', __FILE__), array('jquery'), null, true);

        wp_enqueue_script('ct-celtictuning', plugins_url('assets/js/ct-celtictuning.js', __FILE__), array('jquery'), null, true);

        wp_enqueue_script('ct-shortcode-celtictuning', plugins_url('assets/js/ct-shortcode-script.js', __FILE__), array('jquery'), null, true);

        $options = get_option('ct_celtictuning_settings');

        if (isset($options['enable_recaptcha_v3']) && is_page($options['rootpage']) ) {

            if($options['enable_recaptcha_v3'] == 'true'){

                $recaptcha_site_key = !empty($options['recaptcha_site_key']) ? $options['recaptcha_site_key'] : '';

                wp_enqueue_script('google-recaptcha-v3', 'https://www.google.com/recaptcha/api.js?render=' . $recaptcha_site_key, array(), null, true);

            }

        }

        $root_page_id = isset($options['rootpage']) ? intval($options['rootpage']) : 0;

        $rootPageSlug = get_post_field( 'post_name', $root_page_id );

        if ($root_page_id) {

            $root_page_url = get_permalink($root_page_id);

        } else {

            $root_page_url = home_url();

        }

        wp_localize_script('ct-celtictuning', 'ct_celtictuning', array(

            'ajax_url' => admin_url('admin-ajax.php'),

            'pluginUrl' => plugin_dir_url(__FILE__),

            'nonce'    => wp_create_nonce('request_quote_nonce'),

            'dpfGranted' => !empty($options['dpfGranted']) ? 'true' : 'false',

            'egrGranted' => !empty($options['egrGranted']) ? 'true' : 'false',

            'VMaxRemoval' => !empty($options['VMaxRemoval']) ? 'true' : 'false',

            'AdBlueRemoval' => !empty($options['AdBlueRemoval']) ? 'true' : 'false',

            'SwirlFlapsRemoval' => !empty($options['SwirlFlapsRemoval']) ? 'true' : 'false',

            'O2Removal' => !empty($options['O2Removal']) ? 'true' : 'false',

            'ColdStartRemoval' => !empty($options['ColdStartRemoval']) ? 'true' : 'false',

            'ExhaustFlapRemoval' => !empty($options['ExhaustFlapRemoval']) ? 'true' : 'false',

            'GPFRemoval' => !empty($options['GPFRemoval']) ? 'true' : 'false',

            'Immobiliser' => !empty($options['Immobiliser']) ? 'true' : 'false',

            'LaunchControl' => !empty($options['LaunchControl']) ? 'true' : 'false',

            'RevLimiterRemoval' => !empty($options['RevLimiterRemoval']) ? 'true' : 'false',

            'StopStartRemoval' => !empty($options['StopStartRemoval']) ? 'true' : 'false',

            'termsReq' => !empty($options['termsaccept']) ? 'true' : 'false',

            'termsUrl' => !empty($options['terms']) ? $options['terms'] : '',

            'customPageId' => $options['rootpage'],

            'siteUrl' => get_site_url(),

            'rootPageUrl' => $root_page_url,

            'rootPageSlug' => $rootPageSlug,

            'defaultCountry' => !empty($options['country']) ? $options['country'] : 'GB',

            'enable_recaptcha_v3' => !empty($options['enable_recaptcha_v3']) ? 'true' : 'false',

            'recaptcha_site_key' => !empty($options['recaptcha_site_key']) ? $options['recaptcha_site_key'] : '',

        ));

}

add_action('wp_enqueue_scripts', 'ct_celtictuning_enqueue_scripts_conditionally', 999);



/**

 * Adds custom styles dynamically based on plugin settings.

 * 

 * @since 1.0

 */

function ct_celtictuning_enqueue_styles() {

    $options = get_option('ct_celtictuning_settings');

    if (!is_array($options)) {

        return;

    }

    $title_color = !empty($options['titlecolour']) ? $options['titlecolour'] : '#000';

    $text_color = !empty($options['textcolour']) ? $options['textcolour'] : '#000';

    $submit_button_bg_color = !empty($options['submitcolour']) ? $options['submitcolour'] : 'linear-gradient(90deg, rgb(255, 98, 104) 0%, rgb(237, 28, 36) 100%)';

    $submit_button_text_color = !empty($options['submittextcolour']) ? $options['submittextcolour'] : '#fff';

    $back_button_bg_color = !empty($options['backcolour']) ? $options['backcolour'] : 'linear-gradient(90deg, rgb(84, 84, 84) 0%, rgb(0, 0, 0) 100%)';

    $back_button_text_color = !empty($options['backtextcolour']) ? $options['backtextcolour'] : '#fff';

    $quotes_text_color = !empty($options['contacttextcolour']) ? $options['contacttextcolour'] : 'color: var(--ast-global-color-2);';

    $quotes_bg_color = !empty($options['contactcolour']) ? $options['contactcolour'] : '#fff';

    $accent_color_rectActive = !empty($options['accentcolor']) ? $options['accentcolor'] : 'linear-gradient(90deg, rgb(255, 130, 137) 0%, rgb(237, 28, 36) 100%)';

    $accent_color_chartActive = !empty($options['accentcolor']) ? $options['accentcolor'] : 'linear-gradient(90deg, rgb(255, 130, 137) 0%, rgb(237, 28, 36) 100%)';

    $accent_font_color = !empty($options['accentcolor']) ? $options['accentcolor'] : '#E30613';

    $accent_fill_color = !empty($options['accentcolor']) ? $options['accentcolor'] : '#ED1C24';

    $loader_bg_color = !empty($options['loaderbgcolor']) ? $options['loaderbgcolor'] : 'rgba(255, 130, 137, 0.5);';

    $accent_fill_color = !empty($options['accentcolor']) ? $options['accentcolor'] : '#ED1C24';

    $shortcode_bg_color = !empty($options['shortcodebgcolor']) ? $options['shortcodebgcolor'] : '#000000';

    $shortcode_search_color = !empty($options['shortcodesearchcolor']) ? $options['shortcodesearchcolor'] : 'linear-gradient(90deg, rgb(255, 98, 104) 0%, rgb(237, 28, 36) 100%) !important;';



    echo "<style>

        .ct-select-title { color: {$title_color} !important; }

        .ct-car-name { color: {$text_color} !important; }

        .ct-variant-select-heading { color: {$text_color} !important; }

        .ct-form-submit-button { background: {$submit_button_bg_color} !important; color: {$submit_button_text_color} !important; }

        .ct-form-back-button { background: {$back_button_bg_color} !important; color: {$back_button_text_color} !important; }

        .ct-quotes-text { color: {$quotes_text_color} !important; }

        .ct-modal-content { background: {$quotes_bg_color} !important; }

        .ct-performance-stage-container .rectActive { background: {$accent_color_rectActive} !important; }

        .ct-performance-stage-container .progress .chartActive { background-image: linear-gradient(white, white), linear-gradient(180deg, {$accent_color_chartActive} 0%, {$accent_color_chartActive}  100%) !important; }

        .ct-accent-text { color: {$accent_font_color} !important; }

        .ct-loader-container { background-color: {$loader_bg_color} !important;opacity:0.5; }

        .ct-main-select-bg-shortcode{ background: {$shortcode_bg_color} !important; }

        .ct-main-select-bg-shortcode .ct-submit-button-active button{ background: {$shortcode_search_color} !important; box-shadow: 0px 3px 0px 0px {$shortcode_search_color} !important; }";

        $layout_class = !empty($plugin_settings['shortcodelayout']) && $plugin_settings['shortcodelayout'] === 'vertical'
    ? 'ct-layout-vertical'
    : 'ct-layout-horizontal';

echo '<div class="ct-shortcode-wrapper ' . esc_attr($layout_class) . '">';

    echo "</style>";

    echo "<script>var fillColor = '" . esc_js($accent_fill_color) . "';</script>";

}

add_action('wp_head', 'ct_celtictuning_enqueue_styles');



/**

 * Displays a warning in the editor when editing the page that is replaced by the ct-Celtictuning content.

 * 

 * @since 1.0

 */

function ct_celtictuning_editor_notice() {

    $selected_page = get_option('ct_celtictuning_settings');

    if (!is_array($selected_page)) {

        return;

    }

    $selected_page = $selected_page['rootpage'];

    $screen = get_current_screen();



    if (is_admin() && $screen->base === 'post' && isset($_GET['post']) && $_GET['post'] == $selected_page) {

        echo '<div class="notice notice-warning is-dismissible"><p>This page\'s content will be replaced with the Celtic Tuning plugin\'s content!</p></div>';

    }

}

add_action('admin_notices', 'ct_celtictuning_editor_notice');



/**

 * Creates the request quotes table during plugin activation.

 * 

 * @since 1.0

 */

register_activation_hook(__FILE__, 'ct_create_request_quotes_table');

function ct_create_request_quotes_table() {

    global $wpdb;

    $table_name = $wpdb->prefix . 'ct_request_quotes';

    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (

        id mediumint(9) NOT NULL AUTO_INCREMENT,

        reference varchar(20) NOT NULL,

        customer_name varchar(255) NOT NULL,

        email varchar(255) NOT NULL,

        telephone varchar(50) NOT NULL,

        address varchar(255) NOT NULL,

        post_code varchar(20) NOT NULL,

        city varchar(50) NOT NULL,

        state varchar(50) NOT NULL,

        country varchar(100) NOT NULL,

        additional_comments text NOT NULL,

        variant_id CHAR(50) NOT NULL,

        varient_details CHAR(255) NOT NULL,

        vehicle_year varchar(50) NOT NULL,

        tuning_stage varchar(50) NOT NULL,

        options text NOT NULL,

        consent tinyint(1) NOT NULL,

        marketing tinyint(1) NOT NULL,

        accept tinyint(1) NOT NULL,

        api_details TEXT NOT NULL,

        timestamp datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,

        PRIMARY KEY (id)

    ) $charset_collate;";



    require_once ABSPATH . 'wp-admin/includes/upgrade.php';

    dbDelta($sql);

}



/**

 * Adds a custom rewrite rule for the root page specified in the plugin settings.

 * 

 * @since 1.0

 */

function custom_vehicle_rewrite_rule() {

    $options = get_option('ct_celtictuning_settings');

    if (!is_array($options)) {

        return;

    }

    $root_page_id = isset($options['rootpage']) ? intval($options['rootpage']) : 0;



    if ($root_page_id) {

        $root_page_slug = get_post($root_page_id)->post_name;



        // Add the rewrite rule to match optional "request" at the end of the URL

        add_rewrite_rule(

            '^' . $root_page_slug . '(/([^/]+))?(/([^/]+))?(/([^/]+))?(/([^/]+))?(/([^/]+))?/?$',

            'index.php?pagename=' . $root_page_slug . '&make=$matches[2]&model=$matches[4]&fuel=$matches[6]&variant=$matches[8]&request=$matches[10]',

            'top'

        );

    }

    flush_rewrite_rules();



}

add_action('init', 'custom_vehicle_rewrite_rule');



