<?php
/**
 * Displays vehicle selection form on the specified page from plugin settings.
 * 
 * @since 1.0
 */
function ct_celtictuning_display_on_selected_page($content) {
    $selected_page = get_option('ct_celtictuning_settings');
    if (!is_array($selected_page)) {
        return;
    }

    if (is_page($selected_page['rootpage'])) {
        $makes = ct_celtictuning_fetch_makes();
        if (isset($makes['error'])) {
            ob_start(); 
            ?>
            <div class="ct-container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-danger">
                            <?php echo esc_html($makes['error']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            return ob_get_clean();
        }

        ob_start();
        if($selected_page['hideajaxloader'] != 'true'){
        ?>
        <div class="ct-loader-container" id="loader" style="display: none;">
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
        </div>
        <?php }
          $root_page_id = isset($selected_page['rootpage']) ? intval($selected_page['rootpage']) : 0;
          $root_page_url = get_permalink($root_page_id);
          $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
          $current_url = $protocol . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
          
          if ($current_url == $root_page_url) {
              $hide_form = true;  
          } else {
              $hide_form = false; 
          }
          
          //$display_header = ($selected_page['hidepageheader'] != true || $hide_form == true) ? "display: block;" : "display: none;";
          $display_header = ($selected_page['hidepageheader'] != true) ? "display: block;" : "display: none;";

        ?>
        <div class="ct-container" style="<?php echo $display_header?>">
            <div class="row">
                <div class="col-md-12">
                    
                    <form id="ct-vehicle-form">
                        <div class="ct-main-select-bg">
                            <div class="ct-select-items-car">
                                <div class="ct-select-make">
                                    <div class="form-group">
                                        <select class="form-control ct-custom-arrow-select ct-select-active-menu" id="ct-make-select">
                                            <?php 
                                            if (is_array($makes) && !empty($makes)) {
                                            foreach ($makes as $make): ?>
                                                <option value="<?php echo esc_attr($make['Value']); ?>"><?php echo esc_html($make['Text']); ?></option>
                                            <?php endforeach; 
                                            }else{
                                                echo '<option value="">No Makes Available</option>';
                                            }
                                            ?>
                                                        
                                        </select>
                                    </div>
                                </div>
                                <div class="ct-select-model">
                                    <div class="form-group">
                                        <select id="ct-model-select" class="form-control ct-select-disabled ct-custom-arrow-select">
                                            <option>Select Previous</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="ct-select-fuel">
                                    <div class="form-group">
                                        <select id="ct-fuel-select" class="form-control ct-select-disabled ct-custom-arrow-select">
                                            <option value="">Select Previous</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="ct-select-variant">
                                    <div class="form-group">
                                        <select id="ct-variant-select" class="form-control ct-select-disabled ct-custom-arrow-select">
                                            <option value="">Select Previous</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="ct-submit-button">
                                    <button type="button" id="ct-search-button" class="ct-search-disabled" disabled>Search</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div id="modalContainer"></div>
        <div class="ct-container" id="car-make-images">
            <div class="row">
                <div class="col-md-12">
                    <h2 class="my-4 ct-select-title">Please Select Car Brand</h2>
                </div>
                <?php 
                if (is_array($makes) && !empty($makes)) {

                foreach ($makes as $make): ?>
                    <?php if (!empty($make['ImageUrl'])): ?>
                        <div class="col-md-2 col-6 mb-3">
                            <div class="ct-make-image-container">
                            <picture>
                                <img class="ct-car-make-image" data-make-id="<?php echo esc_attr($make['Value']); ?>" src="<?php echo esc_url($make['ImageUrl']); ?>" alt="<?php echo esc_attr($make['Text']); ?>">
                            </picture>
                            </div>
                            <h3 class="ct-car-name"><?php echo esc_html($make['Text']); ?></h3>
                        </div>
                    <?php endif; ?>
                <?php endforeach;
                }else{
                    echo '<option value="">No Makes Available</option>';
                } ?>
            </div>
        </div>

        

        <?php
        return ob_get_clean();
    }

    return $content;
}
add_filter('the_content', 'ct_celtictuning_display_on_selected_page');

/**
 * Enqueues scripts and styles only on the root page specified in the plugin settings.
 * 
 * @since 1.0
 */
function enqueue_custom_scripts() {
    wp_enqueue_script('dat-gui', 'https://cdnjs.cloudflare.com/ajax/libs/dat-gui/0.7.6/dat.gui.min.js', array(), null, true);
    
    $selected_page = get_option('ct_celtictuning_settings');
    if (!is_array($selected_page)) {
        return;
    }
    if (is_page($selected_page['rootpage'])) {
    ?>
    <script>
        function activeRadio() {
            const allRadioLabels = document.querySelectorAll('.tuningStage');
            allRadioLabels.forEach(label => label.classList.remove('checked'));

            const selectedRadio = document.querySelector('input[name="tuningStageId"]:checked');
            if (selectedRadio) {
                const parentLabel = selectedRadio.closest('.tuningStage');
                if (parentLabel) parentLabel.classList.add('checked');
            }
        }

        function activeCheckbox(checkbox) {
    const confirmationOptions = ['DPF Removal', 'EGR Removal', 'AdBlue Removal'];

    if (confirmationOptions.includes(checkbox.value) && checkbox.checked) {
        let confirmationMessage = '';

        if (checkbox.value === 'DPF Removal') {
            confirmationMessage = `DPF removal requires your DPF filter to have been removed from the exhaust system with pressure sensors in place and working.
Failure to remove can cause damage to your engine. We accept no responsibility for the removal of your DPF if the DPF removal solution is not effective.
Please note that this is an emission control device. Removal of this system may be against the laws of your country.
This is designed for OFF-ROAD USE ONLY and we accept no liability for any laws you may contravene with its usage.`;
        } else if (checkbox.value === 'EGR Removal') {
            confirmationMessage = `EGR removal in most instances requires you to physically blank the EGR off. The solution is generally to turn off the flow control to expect zero gasses.
We can in some cases turn off DTC codes relating to electronic failure. Please contact us before purchasing to ensure we can support this if required.
Please note that this is an emission control device. Removal of this system may be against the laws of your country.
This is designed for OFF-ROAD USE ONLY and we accept no liability for any laws you may contravene with its usage.`;
        } else if (checkbox.value === 'AdBlue Removal') {
            confirmationMessage = `ADBLUE removal may require diagnostics to reset adaption values and may need to have the ADBLUE controller physically disconnected.
Please note that this is an emission control device. Removal of this system may be against the laws of your country.
This is designed for OFF-ROAD USE ONLY and we accept no liability for any laws you may contravene with its usage.`;
        }

        document.getElementById('confirmationMessage').innerText = confirmationMessage;
        $('#confirmationModal').modal('show');

        checkbox.checked = false;

        document.getElementById('confirmButton').onclick = function() {
            checkbox.checked = true; 
            const parentLabel = checkbox.closest('.additional_options');
            if (parentLabel) parentLabel.classList.add('checked');
            $('#confirmationModal').modal('hide'); // Hide the modal
        };

        $('#confirmationModal').on('hidden.bs.modal', function () {
            if (!checkbox.checked) {
                checkbox.checked = false;
            }
        });
    } else if (checkbox.checked) {
        const parentLabel = checkbox.closest('.additional_options');
        if (parentLabel) parentLabel.classList.add('checked');
    } else {
        const parentLabel = checkbox.closest('.additional_options');
        if (parentLabel) parentLabel.classList.remove('checked');
    }
}

    document.addEventListener('DOMContentLoaded', function () {
        let settings = {
            width: 10,
            height: 1,
            color: '#000000'
        };

        const gui = (function datgui() {
            var gui = new dat.GUI();
            gui.add(settings, "height", 1, 50).step(1).onChange(function (newValue) {
                document.documentElement.style.setProperty(`--item-width`, newValue + 'px');
            });
            gui.add(settings, "width", 1, 10).step(1).onChange(function (newValue) {
                document.documentElement.style.setProperty(`--item-height`, newValue + 'px');
            });
            gui.addColor(settings, "color").onChange(function (newValue) {
                document.documentElement.style.setProperty(`--color`, newValue);
            });
            return gui;
        })();
    });
    </script>
    <?php
    }
}
add_action('wp_footer', 'enqueue_custom_scripts');

