<?php

/**

 * Displays the settings page.

 * 

 * @since 1.0

 */

function ct_celtictuning_settings_page() {

    ?>

    <div class="wrap">

        <h1>Celtictuning Settings</h1>

        <?php

        settings_errors('ct_celtictuning_messages'); 

        ?>

        <form method="post" action="options.php">

            <?php

            settings_fields('ct_celtictuning_settings_group');

            do_settings_sections('ct_celtictuning');

            submit_button();

            ?>

        </form>

    </div>

    <?php

}



/**

 * Registers settings and fields.

 * 

 * @since 1.0

 */

function ct_celtictuning_register_settings() {

    register_setting('ct_celtictuning_settings_group', 'ct_celtictuning_settings',  'ct_celtictuning_sanitize_settings');



    if (isset($_GET['settings-updated'])) {

        add_settings_error('ct_celtictuning_messages', 'ct_celtictuning_message', 'Settings saved successfully!', 'updated');

    }



    add_settings_section('ct_celtictuning_section', '', null, 'ct_celtictuning');



    add_settings_field('recipient_email', 'Request Quote\'s recipient e-mail', 'ct_celtictuning_recipient_email_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('apikey', 'API Key', 'ct_celtictuning_apikey_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('business_name', 'Business Name', 'ct_celtictuning_business_name_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('accentcolor', 'Accent Color', 'ct_celtictuning_accentcolor_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('rootpage', 'Root Page', 'ct_celtictuning_rootpage_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('country', 'Country', 'ct_celtictuning_country_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('terms', 'Terms and Conditions link', 'ct_celtictuning_terms_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('termsaccept', 'Terms & Conditions field required?', 'ct_celtictuning_termsaccept_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('grantedTitle','<h1>Blocking options from vehicles</h1>','ct_granted_callback','ct_celtictuning','ct_celtictuning_section');

    add_settings_field('dpfGranted', 'Block DPF option', 'ct_celtictuning_dpfGranted_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('egrGranted', 'Block EGR option', 'ct_celtictuning_egrGranted_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('VMaxRemoval', 'Block VMax option', 'ct_celtictuning_VMaxRemoval_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('AdBlueRemoval', 'Block AdBlue option', 'ct_celtictuning_AdBlueRemoval_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('SwirlFlapsRemoval', 'Block SwirlFlaps option', 'ct_celtictuning_SwirlFlapsRemoval_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('O2Removal', 'Block O2Removal option', 'ct_celtictuning_O2Removal_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('ColdStartRemoval', 'Block ColdStart option', 'ct_celtictuning_ColdStartRemoval_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('ExhaustFlapRemoval', 'Block ExhaustFlap option', 'ct_celtictuning_ExhaustFlapRemoval_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('GPFRemoval', 'Block GPF option', 'ct_celtictuning_GPFRemoval_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('Immobiliser', 'Block Immobiliser option', 'ct_celtictuning_Immobiliser_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('LaunchControl', 'Block LaunchControl option', 'ct_celtictuning_LaunchControl_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('RevLimiterRemoval', 'Block RevLimiter option', 'ct_celtictuning_RevLimiterRemoval_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('StopStartRemoval', 'Block StopStart option', 'ct_celtictuning_StopStartRemoval_callback', 'ct_celtictuning', 'ct_celtictuning_section',[

        'class' => 'ctr-custom-class'

    ]);

    add_settings_field('main','<h1>Contact page styling settings</h1>', 'ct_main_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('title','<h2>Text colour</h2>', 'ct_title_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('titlecolour', 'Title Colour', 'ct_celtictuning_titlecolour_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('textcolour', 'Text Colour', 'ct_celtictuning_textcolour_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('contact','<h2>Stage/Options/Contact button styling</h2>', 'ct_contact_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('contacttextcolour', 'Contact Text Colour', 'ct_celtictuning_contacttextcolour_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('contactcolour', 'Contact Background Colour', 'ct_celtictuning_contactcolour_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('submit', '<h2>Submit button styling</h2>', 'ct_submit_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('submitcolour', 'Submit Button Background Colour', 'ct_celtictuning_submitcolour_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('submittextcolour', 'Submit Button Text Colour', 'ct_celtictuning_submittextcolour_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('back', '<h2>Back button colour settings</h2>', 'ct_back_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('backcolour', 'Back Button Background Colour', 'ct_celtictuning_backcolour_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('backtextcolour', 'Back Button Text Colour', 'ct_celtictuning_backtextcolour_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('loader', '<h2>Loader settings</h2>', 'ct_loader_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('hideajaxloader', 'Disabled loader?', 'ct_celtictuning_hideajaxloader_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('loaderbgcolor', 'Loader Background Colour', 'ct_celtictuning_loaderbgcolor_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('shortcode', '<h2>Shortcode layout settings</h2>', 'ct_shortcode_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('shortcodelayout', 'Shortcode Layout', 'ct_celtictuning_shortcode_layout_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('shortcodebgcolor', 'Shortcode Background Colour', 'ct_celtictuning_shortcode_bgcolor_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('shortcodesearchcolor', 'Shortcode Search Button Colour', 'ct_celtictuning_shortcode_search_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('hidepageheader', 'Hide the header of the root page when using a shortcode.', 'ct_celtictuning_hidepageheader_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    //add_settings_field('clear_web_quote_requests', 'Clear Web Quote Requests', 'ct_celtictuning_clear_web_quote_requests_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('reCAPTCHA', '<h2>Google reCAPTCHA v3 Settings</h2>', 'ct_reCAPTCHA_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('enable_recaptcha_v3', 'Enable Google reCAPTCHA v3', 'ct_celtictuning_enable_recaptcha_v3_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('recaptcha_site_key', 'Site Key', 'ct_celtictuning_recaptcha_site_key_callback', 'ct_celtictuning', 'ct_celtictuning_section');

    add_settings_field('recaptcha_secret_key', 'Secret Key', 'ct_celtictuning_recaptcha_secret_key_callback', 'ct_celtictuning', 'ct_celtictuning_section');



}

add_action('admin_init', 'ct_celtictuning_register_settings');



/**

 * Sanitizes input data.

 * 

 * @since 1.0

 */

function ct_celtictuning_sanitize_settings($input) {

    $input['recipient_email'] = isset($input['recipient_email']) ? sanitize_text_field($input['recipient_email']) : '';

    $input['business_name']   = isset($input['business_name']) ? sanitize_text_field($input['business_name']) : '';

    $input['apikey']          = isset($input['apikey']) ? sanitize_text_field($input['apikey']) : '';

    $input['accentcolor']     = isset($input['accentcolor']) ? sanitize_text_field($input['accentcolor']) : '';

    $input['rootpage']        = isset($input['rootpage']) ? sanitize_text_field($input['rootpage']) : '';

    $input['country']         = isset($input['country']) ? sanitize_text_field($input['country']) : '';

    $input['terms']           = isset($input['terms']) ? sanitize_text_field($input['terms']) : '';

    $input['termsaccept']     = isset($input['termsaccept']) ? sanitize_text_field($input['termsaccept']) : '';

    $input['dpfGranted']      = isset($input['dpfGranted']) ? sanitize_text_field($input['dpfGranted']) : '';

    $input['egrGranted']      = isset($input['egrGranted']) ? sanitize_text_field($input['egrGranted']) : '';

    $input['titlecolour']     = isset($input['titlecolour']) ? sanitize_text_field($input['titlecolour']) : '';

    $input['textcolour']      = isset($input['textcolour']) ? sanitize_text_field($input['textcolour']) : '';

    $input['contacttextcolour'] = isset($input['contacttextcolour']) ? sanitize_text_field($input['contacttextcolour']) : '';

    $input['contactcolour']   = isset($input['contactcolour']) ? sanitize_text_field($input['contactcolour']) : '';

    $input['submitcolour']    = isset($input['submitcolour']) ? sanitize_text_field($input['submitcolour']) : '';

    $input['submittextcolour'] = isset($input['submittextcolour']) ? sanitize_text_field($input['submittextcolour']) : '';

    $input['backcolour']      = isset($input['backcolour']) ? sanitize_text_field($input['backcolour']) : '';

    $input['backtextcolour']  = isset($input['backtextcolour']) ? sanitize_text_field($input['backtextcolour']) : '';

    $input['acceptcolour']    = isset($input['acceptcolour']) ? sanitize_text_field($input['acceptcolour']) : '';

    $input['loaderbgcolor']   = isset($input['loaderbgcolor']) ? sanitize_text_field($input['loaderbgcolor']) : '';

    $input['hideajaxloader']  = isset($input['hideajaxloader']) ? sanitize_text_field($input['hideajaxloader']) : '';

    $input['shortcodebgcolor'] = isset($input['shortcodebgcolor']) ? sanitize_text_field($input['shortcodebgcolor']) : '';

    $input['shortcodelayout'] = isset($input['shortcodelayout']) ? sanitize_text_field($input['shortcodelayout']) : '';

    $input['shortcodesearchcolor'] = isset($input['shortcodesearchcolor']) ? sanitize_text_field($input['shortcodesearchcolor']) : '';

    $input['hidepageheader']  = isset($input['hidepageheader']) ? sanitize_text_field($input['hidepageheader']) : '';

    $input['clear_web_quote_requests'] = isset($input['clear_web_quote_requests']) ? sanitize_text_field($input['clear_web_quote_requests']) : '';

    $input['enable_recaptcha_v3']  = isset($input['enable_recaptcha_v3']) ? sanitize_text_field($input['enable_recaptcha_v3']) : '';

    $input['recaptcha_site_key']   = isset($input['recaptcha_site_key']) ? sanitize_text_field($input['recaptcha_site_key']) : '';

    $input['recaptcha_secret_key'] = isset($input['recaptcha_secret_key']) ? sanitize_text_field($input['recaptcha_secret_key']) : '';



    return $input;

}



/**

 * Callback for the recipient email field.

 * 

 * @since 1.0

 */

function ct_celtictuning_recipient_email_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="email" name="ct_celtictuning_settings[recipient_email]" value="' . esc_attr($options['recipient_email'] ?? '') . '" size="45" />';

}



/**

 * Callback for the API key field.

 * 

 * @since 1.0

 */

function ct_celtictuning_apikey_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[apikey]" value="' . esc_attr($options['apikey'] ?? '') . '" size="45" />';

}



/**

 * Callback for the business name field.

 * 

 * @since 1.0

 */

function ct_celtictuning_business_name_callback() {

    $options = get_option('ct_celtictuning_settings');



    $business_name = !empty($options['business_name']) ? esc_attr($options['business_name']) : 'Celtic Tuning';



    echo '<input type="text" name="ct_celtictuning_settings[business_name]" value="' . $business_name . '" size="45" />';

}



/**

 * Callback for the accent color field.

 * 

 * @since 1.0

 */

function ct_celtictuning_accentcolor_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[accentcolor]" value="' . esc_attr($options['accentcolor'] ?? '') . '" size="45" />';

}



/**

 * Callback for the root page field.

 * 

 * @since 1.0

 */

function ct_celtictuning_rootpage_callback() {

    $options = get_option('ct_celtictuning_settings');

    $pages = get_pages();

    echo '<select name="ct_celtictuning_settings[rootpage]">';

    foreach ($pages as $page) {

        $selected = $options['rootpage'] == $page->ID ? 'selected="selected"' : '';

        echo '<option value="' . esc_attr($page->ID) . '" ' . $selected . '>' . esc_html($page->post_title) . '</option>';

    }

    echo '</select>';

    echo '<p class="description">Note: The selected page\'s content will be replaced with the Celtictuning plugin\'s content.</p>';

    echo '<ol>

        <li><a target="_blank" href="post-new.php?post_type=page&amp;post_title=Vehicle+Stats&amp;content=This+page%27s+contents+will+be+replaced.">Create a new page</a></li>

        <li>Assign it to your <strong>menu</strong>, and <strong>remember to come back</strong> here to set it as a root page!</li>

        <li><a href="options-permalink.php">Go to the permalinks settings page and click "Save Changes". Your new page will work now.</a></li>

      </ol>';

}



/**

 * Callback for the country field.

 * 

 * @since 1.0

 */

function ct_celtictuning_country_callback() {

    $options = get_option('ct_celtictuning_settings');

    $countries = [

        'AF' => 'Afghanistan', 'AL' => 'Albania', 'DZ' => 'Algeria', 'AS' => 'American Samoa',

        'AD' => 'Andorra', 'AO' => 'Angola', 'AI' => 'Anguilla', 'AG' => 'Antigua and Barbuda',

        'AR' => 'Argentina', 'AM' => 'Armenia', 'AW' => 'Aruba', 'AU' => 'Australia',

        'AT' => 'Austria', 'AZ' => 'Azerbaijan', 'BS' => 'Bahamas', 'BH' => 'Bahrain',

        'BD' => 'Bangladesh', 'BB' => 'Barbados', 'BY' => 'Belarus', 'BE' => 'Belgium',

        'BZ' => 'Belize', 'BJ' => 'Benin', 'BM' => 'Bermuda', 'BT' => 'Bhutan',

        'BO' => 'Bolivia, Plurinational State of', 'BA' => 'Bosnia and Herzegovina', 'BW' => 'Botswana',

        'BR' => 'Brazil', 'BG' => 'Bulgaria', 'BF' => 'Burkina Faso', 'BI' => 'Burundi',

        'KH' => 'Cambodia', 'CM' => 'Cameroon', 'CA' => 'Canada', 'CV' => 'Cape Verde',

        'KY' => 'Cayman Islands', 'CF' => 'Central African Republic', 'TD' => 'Chad',

        'CL' => 'Chile', 'CN' => 'China', 'CO' => 'Colombia', 'KM' => 'Comoros',

        'CK' => 'Cook Islands', 'CR' => 'Costa Rica', 'CI' => "Côte d'Ivoire", 'HR' => 'Croatia',

        'CU' => 'Cuba', 'CY' => 'Cyprus', 'CZ' => 'Czech Republic', 'DK' => 'Denmark',

        'DJ' => 'Djibouti', 'DM' => 'Dominica', 'DO' => 'Dominican Republic', 'EC' => 'Ecuador',

        'EG' => 'Egypt', 'SV' => 'El Salvador', 'GQ' => 'Equatorial Guinea', 'ER' => 'Eritrea',

        'EE' => 'Estonia', 'ET' => 'Ethiopia', 'FI' => 'Finland', 'FR' => 'France',

        'GF' => 'French Guiana', 'PF' => 'French Polynesia', 'GA' => 'Gabon', 'GM' => 'Gambia',

        'GE' => 'Georgia', 'DE' => 'Germany', 'GI' => 'Gibraltar', 'GR' => 'Greece',

        'GL' => 'Greenland', 'GD' => 'Grenada', 'GP' => 'Guadeloupe', 'GU' => 'Guam',

        'GT' => 'Guatemala', 'GG' => 'Guernsey', 'GN' => 'Guinea', 'GW' => 'Guinea-Bissau',

        'GY' => 'Guyana', 'HT' => 'Haiti', 'HN' => 'Honduras', 'HK' => 'Hong Kong',

        'HU' => 'Hungary', 'IS' => 'Iceland', 'IN' => 'India', 'ID' => 'Indonesia',

        'IR' => 'Iran, Islamic Republic of', 'IQ' => 'Iraq', 'IE' => 'Ireland', 'IL' => 'Israel',

        'IT' => 'Italy', 'JM' => 'Jamaica', 'JP' => 'Japan', 'JE' => 'Jersey',

        'JO' => 'Jordan', 'KZ' => 'Kazakhstan', 'KE' => 'Kenya', 'KI' => 'Kiribati',

        'KP' => "Korea, Democratic People's Republic of", 'KR' => 'Korea, Republic of', 

        'KW' => 'Kuwait', 'KG' => 'Kyrgyzstan', 'LA' => "Lao People's Democratic Republic", 

        'LV' => 'Latvia', 'LB' => 'Lebanon', 'LS' => 'Lesotho', 'LR' => 'Liberia',

        'LY' => 'Libya', 'LI' => 'Liechtenstein', 'LT' => 'Lithuania', 'LU' => 'Luxembourg',

        'MO' => 'Macao', 'MK' => 'Macedonia, the former Yugoslav Republic of', 'MG' => 'Madagascar',

        'MW' => 'Malawi', 'MY' => 'Malaysia', 'MV' => 'Maldives', 'ML' => 'Mali',

        'MT' => 'Malta', 'MH' => 'Marshall Islands', 'MQ' => 'Martinique', 'MR' => 'Mauritania',

        'MU' => 'Mauritius', 'YT' => 'Mayotte', 'MX' => 'Mexico', 'FM' => 'Micronesia, Federated States of',

        'MD' => 'Moldova, Republic of', 'MC' => 'Monaco', 'MN' => 'Mongolia', 'ME' => 'Montenegro',

        'MS' => 'Montserrat', 'MA' => 'Morocco', 'MZ' => 'Mozambique', 'MM' => 'Myanmar',

        'NA' => 'Namibia', 'NR' => 'Nauru', 'NP' => 'Nepal', 'NL' => 'Netherlands',

        'NC' => 'New Caledonia', 'NZ' => 'New Zealand', 'NI' => 'Nicaragua', 'NE' => 'Niger',

        'NG' => 'Nigeria', 'NU' => 'Niue', 'MP' => 'Northern Mariana Islands', 'NO' => 'Norway',

        'OM' => 'Oman', 'PK' => 'Pakistan', 'PA' => 'Panama', 'PG' => 'Papua New Guinea',

        'PY' => 'Paraguay', 'PE' => 'Peru', 'PH' => 'Philippines', 'PL' => 'Poland',

        'PT' => 'Portugal', 'PR' => 'Puerto Rico', 'QA' => 'Qatar', 'RE' => 'Réunion',

        'RO' => 'Romania', 'RU' => 'Russian Federation', 'RW' => 'Rwanda', 

        'KN' => 'Saint Kitts and Nevis', 'LC' => 'Saint Lucia', 'VC' => 'Saint Vincent and the Grenadines',

        'WS' => 'Samoa', 'SM' => 'San Marino', 'ST' => 'Sao Tome and Principe', 

        'SA' => 'Saudi Arabia', 'SN' => 'Senegal', 'RS' => 'Serbia', 'SC' => 'Seychelles',

        'SL' => 'Sierra Leone', 'SG' => 'Singapore', 'SK' => 'Slovakia', 

        'SI' => 'Slovenia', 'SB' => 'Solomon Islands', 'SO' => 'Somalia', 

        'ZA' => 'South Africa', 'ES' => 'Spain', 'LK' => 'Sri Lanka', 

        'SD' => 'Sudan', 'SR' => 'Suriname', 'SZ' => 'Swaziland', 

        'SE' => 'Sweden', 'CH' => 'Switzerland', 'SY' => 'Syrian Arab Republic', 

        'TW' => 'Taiwan, Province of China', 'TZ' => 'Tanzania, United Republic of', 

        'TH' => 'Thailand', 'TG' => 'Togo', 'TO' => 'Tonga', 

        'TT' => 'Trinidad and Tobago', 'TN' => 'Tunisia', 'TR' => 'Turkey', 

        'TC' => 'Turks and Caicos Islands', 'TV' => 'Tuvalu', 'UG' => 'Uganda', 

        'UA' => 'Ukraine', 'AE' => 'United Arab Emirates', 

        'GB' => 'United Kingdom', 'US' => 'United States', 

        'UY' => 'Uruguay', 'UZ' => 'Uzbekistan', 'VU' => 'Vanuatu', 

        'VE' => 'Venezuela, Bolivarian Republic of', 'VN' => 'Viet Nam', 

        'VG' => 'Virgin Islands, British', 'VI' => 'Virgin Islands, U.S.', 

        'YE' => 'Yemen', 'ZM' => 'Zambia', 'ZW' => 'Zimbabwe'

    ];



    echo '<select name="ct_celtictuning_settings[country]">';

    foreach ($countries as $code => $name) {

        $selected = (isset($options['country']) && $options['country'] === $code) ? 'selected="selected"' : '';

        echo '<option value="' . esc_attr($code) . '" ' . $selected . '>' . esc_html($name) . '</option>';

    }

    echo '</select>';

}



/**

 * Callback for the terms field.

 * 

 * @since 1.0

 */

function ct_celtictuning_terms_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[terms]" value="' . esc_attr($options['terms'] ?? '') . '" size="45" />';

}



/**

 * Callback for the terms acceptance field.

 * 

 * @since 1.0

 */

function ct_celtictuning_termsaccept_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['termsaccept']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[termsaccept]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the granted field.

 * 

 * @since 1.0

 */

function ct_granted_callback() {

    echo "<p>Some countries have banned the sale of certain options, here you can block the option appearing on your vehicles.</p>";

}



/**

 * Callback for the dpfGranted field.

 * 

 * @since 1.0

 */

function ct_celtictuning_dpfGranted_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['dpfGranted']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[dpfGranted]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the egrGranted field.

 * 

 * @since 1.0

 */

function ct_celtictuning_egrGranted_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['egrGranted']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[egrGranted]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the VMaxRemoval field.

 * 

 * @since 1.0

 */

function ct_celtictuning_VMaxRemoval_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['VMaxRemoval']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[VMaxRemoval]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the AdBlueRemoval field.

 * 

 * @since 1.0

 */

function ct_celtictuning_AdBlueRemoval_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['AdBlueRemoval']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[AdBlueRemoval]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the SwirlFlapsRemoval field.

 * 

 * @since 1.0

 */

function ct_celtictuning_SwirlFlapsRemoval_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['SwirlFlapsRemoval']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[SwirlFlapsRemoval]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the O2Removal field.

 * 

 * @since 1.0

 */

function ct_celtictuning_O2Removal_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['O2Removal']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[O2Removal]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the ColdStartRemoval field.

 * 

 * @since 1.0

 */

function ct_celtictuning_ColdStartRemoval_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['ColdStartRemoval']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[ColdStartRemoval]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the ExhaustFlapRemoval field.

 * 

 * @since 1.0

 */

function ct_celtictuning_ExhaustFlapRemoval_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['ExhaustFlapRemoval']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[ExhaustFlapRemoval]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the GPFRemoval field.

 * 

 * @since 1.0

 */

function ct_celtictuning_GPFRemoval_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['GPFRemoval']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[GPFRemoval]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the Immobiliser field.

 * 

 * @since 1.0

 */

function ct_celtictuning_Immobiliser_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['Immobiliser']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[Immobiliser]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the LaunchControl field.

 * 

 * @since 1.0

 */

function ct_celtictuning_LaunchControl_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['LaunchControl']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[LaunchControl]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the RevLimiterRemoval field.

 * 

 * @since 1.0

 */

function ct_celtictuning_RevLimiterRemoval_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['RevLimiterRemoval']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[RevLimiterRemoval]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the StopStartRemoval field.

 * 

 * @since 1.0

 */

function ct_celtictuning_StopStartRemoval_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['StopStartRemoval']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[StopStartRemoval]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the label field.

 * 

 * @since 1.0

 */

function ct_main_callback() {

   

    echo '<p>Please note the following fields will help you customise the look and feel of the plugin to match your overall website styling. The fields require HEX COLOUR CODES. To help you select your colours in hex please visit <a href="https://htmlcolorcodes.com/color-picker/">here</a></p>';

}



/**

 * Callback for the titlecolour field.

 * 

 * @since 1.0

 */

function ct_celtictuning_titlecolour_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[titlecolour]" value="' . esc_attr($options['titlecolour'] ?? '') . '" size="45" />';

}



/**

 * Callback for the textcolour field.

 * 

 * @since 1.0

 */

function ct_celtictuning_textcolour_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[textcolour]" value="' . esc_attr($options['textcolour'] ?? '') . '" size="45" />';

}



/**

 * Callback for the contacttextcolour field.

 * 

 * @since 1.0

 */

function ct_celtictuning_contacttextcolour_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[contacttextcolour]" value="' . esc_attr($options['contacttextcolour'] ?? '') . '" size="45" />';

}



/**

 * Callback for the contactcolour field.

 * 

 * @since 1.0

 */

function ct_celtictuning_contactcolour_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[contactcolour]" value="' . esc_attr($options['contactcolour'] ?? '') . '" size="45" />';

}



/**

 * Callback for the submitcolour field.

 * 

 * @since 1.0

 */

function ct_celtictuning_submitcolour_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[submitcolour]" value="' . esc_attr($options['submitcolour'] ?? '') . '" size="45" />';

}



/**

 * Callback for the submittextcolour field.

 * 

 * @since 1.0

 */

function ct_celtictuning_submittextcolour_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[submittextcolour]" value="' . esc_attr($options['submittextcolour'] ?? '') . '" size="45" />';

}



/**

 * Callback for the backcolour field.

 * 

 * @since 1.0

 */

function ct_celtictuning_backcolour_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[backcolour]" value="' . esc_attr($options['backcolour'] ?? '') . '" size="45" />';

}



/**

 * Callback for the backtextcolour field.

 * 

 * @since 1.0

 */

function ct_celtictuning_backtextcolour_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[backtextcolour]" value="' . esc_attr($options['backtextcolour'] ?? '') . '" size="45" />';

}



/**

 * Callback for the loaderbgcolor field.

 * 

 * @since 1.0

 */

function ct_celtictuning_loaderbgcolor_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[loaderbgcolor]" value="' . esc_attr($options['loaderbgcolor'] ?? '') . '" size="45" />';

}



/**

 * Callback for the hideajaxloader field.

 * 

 * @since 1.0

 */

function ct_celtictuning_hideajaxloader_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['hideajaxloader']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[hideajaxloader]" value="true" ' . $checked . ' />';

}





/**

 * Callback for the acceptcolour field.

 * 

 * @since 1.0

 */

function ct_celtictuning_acceptcolour_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[acceptcolour]" value="' . esc_attr($options['acceptcolour'] ?? '') . '" size="45" />';

}



/**

 * Callback for the shortcoderbgcolor field.

 * 

 * @since 1.0

 */

function ct_celtictuning_shortcode_bgcolor_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[shortcodebgcolor]" value="' . esc_attr($options['shortcodebgcolor'] ?? '') . '" size="45" />';

}



/**

 * Callback for the shortcodelayout field.

 * 

 * @since 1.0

 */

function ct_celtictuning_shortcode_layout_callback() {

    $options = get_option('ct_celtictuning_settings');

    $layout = $options['shortcodelayout'] ?? 'horizontal';

    

    echo '<label>';

    echo '<input type="radio" name="ct_celtictuning_settings[shortcodelayout]" value="horizontal" ' . checked($layout, 'horizontal', false) . ' />';

    echo __('Horizontal', 'textdomain');

    echo '</label>&nbsp;&nbsp;';



    echo '<label>';

    echo '<input type="radio" name="ct_celtictuning_settings[shortcodelayout]" value="vertical" ' . checked($layout, 'vertical', false) . ' />';

    echo __('Vertical', 'textdomain');

    echo '</label>';

    

    echo '</fieldset>';

}





/**

 * Callback for the shortcodesearchcolor field.

 * 

 * @since 1.0

 */

function ct_celtictuning_shortcode_search_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[shortcodesearchcolor]" value="' . esc_attr($options['shortcodesearchcolor'] ?? '') . '" size="45" />';

}



/**

 * Callback for the hideajaxloader field.

 * 

 * @since 1.0

 */

function ct_celtictuning_hidepageheader_callback() {

    $options = get_option('ct_celtictuning_settings');

    

    $hidepageheader = isset($options['hidepageheader']) ? $options['hidepageheader'] : 'true';

    $checked = ($hidepageheader === 'true') ? 'checked="checked"' : '';

    

    echo '<input type="checkbox" name="ct_celtictuning_settings[hidepageheader]" value="true" ' . $checked . ' />';

}





/**

 * Callback for displaying a heading for the "Text Colour" section.

 * 

 * This function is empty because it is only used to render the label/heading for the section.

 * 

 * @since 1.0

 */

function ct_title_callback() {

}



/**

 * Callback for displaying a heading for the "Contact button styling" section.

 * 

 * This function is empty because it is only used to render the label/heading for the section.

 * 

 * @since 1.0

 */

function ct_contact_callback() {

}



/**

 * Callback for displaying a heading for the "Submit button styling" section.

 * 

 * This function is empty because it is only used to render the label/heading for the section.

 * 

 * @since 1.0

 */

function ct_submit_callback() {

}



/**

 * Callback for displaying a heading for the "Back button colour settings" section.

 * 

 * This function is empty because it is only used to render the label/heading for the section.

 * 

 * @since 1.0

 */

function ct_back_callback() {

}



/**

 * Callback for displaying a heading for the "Loader colour settings" section.

 * 

 * This function is empty because it is only used to render the label/heading for the section.

 * 

 * @since 1.0

 */

function ct_loader_callback() {

}



/**

 * Callback for displaying a heading for the "Shortcode's settings" section.

 * 

 * This function is empty because it is only used to render the label/heading for the section.

 * 

 * @since 1.0

 */

function ct_shortcode_callback() {

    echo "<p>Note: Use the shortcode [celtic_vehicle_form] to display Celtic Tuning's vehicle form. </p>";

}





/**

 * Callback function for rendering the dropdown to select the interval for clearing web quote requests.

 *

 * This function retrieves the current settings for clearing web quote requests and displays a 

 * dropdown with options to select the interval (1, 3, 6, or 12 months). It updates the reset 

 * date based on the selected interval and displays the last reset date and the next scheduled 

 * reset date if available.

 *

 * @since 1.0

 */

function ct_celtictuning_clear_web_quote_requests_callback() {

    $options = get_option('ct_celtictuning_settings');

    

    $selected_value = isset($options['clear_web_quote_requests']) ? $options['clear_web_quote_requests'] : ''; 



    echo '<select name="ct_celtictuning_settings[clear_web_quote_requests]">';

    

    $options_list = [

        '1' => '1 Month',

        '3' => '3 Months',

        '6' => '6 Months',

        '12' => '12 Months',

    ];



    foreach ($options_list as $value => $label) {

        $selected = ($value == $selected_value) ? 'selected="selected"' : '';

        echo "<option value=\"$value\" $selected>$label</option>";

    }

       echo '</select>';

    

        if (!empty($selected_value)) {

            $new_reset_date = calculate_reset_date();

            update_option('ctr_plugin_reset_date', $new_reset_date);  

        }

        $last_reset_date = get_option('ctr_plugin_last_reset_date');

        $reset_date = get_option('ctr_plugin_reset_date');



    if ($last_reset_date) {

        echo '<p class="description">Last Reset Date - ' . esc_html($last_reset_date) . '.</p>';

    }

    if ($reset_date) {

        echo '<p class="description">The Quote Requests data will reset on ' . esc_html($reset_date) . '.</p>';

    }



}



/**

 * Callback for displaying a heading for the "reCAPTCHA v3" section.

 * 

 * @since 1.0

 */

function ct_reCAPTCHA_callback() {

    echo "<p>Note: Manage the Google reCAPTCHA v3 integration for your site. </p>";

}



/**

 * Callback for the enable recaptcha v3 field.

 * 

 * @since 1.0

 */

function ct_celtictuning_enable_recaptcha_v3_callback() {

    $options = get_option('ct_celtictuning_settings');

    $checked = !empty($options['enable_recaptcha_v3']) ? 'checked="checked"' : '';

    echo '<input type="checkbox" name="ct_celtictuning_settings[enable_recaptcha_v3]" value="true" ' . $checked . ' />';

}



/**

 * Callback for the reCAPTCHA v3 site key field.

 * 

 * @since 1.0

 */

function ct_celtictuning_recaptcha_site_key_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[recaptcha_site_key]" value="' . esc_attr($options['recaptcha_site_key'] ?? '') . '" size="45" />';

}



/**

 * Callback for the reCAPTCHA v3 secret key field.

 *

 * @since 1.0

 */

function ct_celtictuning_recaptcha_secret_key_callback() {

    $options = get_option('ct_celtictuning_settings');

    echo '<input type="text" name="ct_celtictuning_settings[recaptcha_secret_key]" value="' . esc_attr($options['recaptcha_secret_key'] ?? '') . '" size="45" />';

}



/**

 * Outputs custom CSS styles for the WordPress admin area to adjust padding

 * for table rows with the class "ctr-custom-class".

 * 

 * This function uses the 'admin_head' action to inject the styles directly

 * into the page header, ensuring the styles take effect in the admin dashboard.

 * 

 * @since 1.0

 */

function custom_admin_css() {

    ?>

    <style>

    tr.ctr-custom-class th {

        padding-top: 0px !important;

        padding-bottom: 10px !important;

    }

    tr.ctr-custom-class td {

        padding-top: 0px !important;

        padding-bottom: 10px !important;

    }

    #ct_request_quote_filter {

     margin-top: 10px !important;

     margin-bottom: 10px !important;

    }

    </style>

    <?php

}

add_action('admin_head', 'custom_admin_css');



?>

