<?php
function ct_vehicle_form_shortcode() {
    ob_start(); 
    $plugin_settings = get_option('ct_celtictuning_settings');
    if (!is_array($plugin_settings)) {
        return;
    }

    $makes = ct_celtictuning_fetch_makes();

    $layout_class = !empty($plugin_settings['shortcodelayout']) && $plugin_settings['shortcodelayout'] === 'vertical'
    ? 'ct-layout-vertical'
    : 'ct-layout-horizontal';

echo '<div class="ct-shortcode-wrapper ' . esc_attr($layout_class) . '">';

    if (isset($makes['error'])) {
        ?>
        <div class="ct-container">
            <div class="ct-row">
                <div class="ct-col-12">
                    <div class="ct-alert ct-alert-danger">
                        <?php echo esc_html($makes['error']); ?>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <?php
        return ob_get_clean();
    }
    ?>
    <div class="ct-container">
        <div class="ct-row">
            <div class="ct-col-12">
                <form id="ct-vehicle-form" method="post">
                    <h3 class="ct-car-name">SELECT YOUR VEHICLE</h3>
                    <div class="ct-main-select-bg-shortcode">
                        <div class="ct-select-items-car">
                            <div class="ct-select-make">
                                <div class="ct-loader-container-option" id="loader_shortcode" style="display: none;">
                                    <?php for ($i = 0; $i < 40; $i++) echo '<div></div>'; ?>
                                </div>
                                <div class="ct-form-group">
                                    <select class="ct-form-control ct-custom-arrow-select ct-select-active-menu" id="ct-make-select-option">
                                        <?php
                                        if (is_array($makes) && !empty($makes)) {
                                            foreach ($makes as $make): ?>
                                                <option value="<?php echo esc_attr($make['Value']); ?>"><?php echo esc_html($make['Text']); ?></option>
                                            <?php endforeach;
                                        } else {
                                            echo '<option value="">No Makes Available</option>';
                                        } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="ct-select-model">
                                <div class="ct-form-group">
                                    <select id="ct-model-select-option" class="ct-form-control ct-select-disabled ct-custom-arrow-select">
                                        <option>Select Previous</option>
                                    </select>
                                </div>
                            </div>

                            <div class="ct-select-fuel">
                                <div class="ct-form-group">
                                    <select id="ct-fuel-select-option" class="ct-form-control ct-select-disabled ct-custom-arrow-select">
                                        <option value="">Select Previous</option>
                                    </select>
                                </div>
                            </div>

                            <div class="ct-select-variant">
                                <div class="ct-form-group">
                                    <select id="ct-variant-select-option" class="ct-form-control ct-select-disabled ct-custom-arrow-select">
                                        <option value="">Select Previous</option>
                                    </select>
                                </div>
                            </div>

                            <div class="ct-submit-button">
                                <button type="button" id="ct-search-button-option" class="ct-search-disabled" disabled>Search</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    </div> <!-- .ct-shortcode-wrapper -->
    <?php
    return ob_get_clean();
}

add_shortcode('celtic_vehicle_form', 'ct_vehicle_form_shortcode');
